<?php
/*
Plugin Name: Divi Blog Extras
Plugin URI:  https://diviextended.com
Description: Add new blog layouts in Divi and Extra theme
Version:     2.1.2
Author:      Elicus Technologies
Author URI:  https://elicus.com
Text Domain: et_builder
*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

define( 'ELICUS_BLOG_OPTION', 'el-divi-blog-extras' );
define( 'ELICUS_BLOG_VERSION', '2.1.2' );

require_once plugin_dir_path( __FILE__ ) . 'includes/src/class-installation.php';
register_activation_hook( __FILE__, array( 'El_Blog_Installation', 'el_plugin_add_installs' ) );
register_deactivation_hook( __FILE__, array( 'El_Blog_Installation', 'el_plugin_remove_installs' ) );

require_once plugin_dir_path( __FILE__ ) . 'includes/backward-compat/compat.php';

if ( ! function_exists( 'el_blog_initialize_extension' ) ) {
    /**
     * Creates the extension's main class instance.
     *
     * @since 2.1.0
     */
    function el_blog_initialize_extension() {
    	require_once plugin_dir_path( __FILE__ ) . 'includes/DiviBlogExtras.php';
    }
    add_action( 'divi_extensions_init', 'el_blog_initialize_extension' );
}