<?php
if ( ! function_exists( 'el_blog_back_compat_init' ) ) {
    function el_blog_back_compat_init() {
        $theme      = wp_get_theme();
    	$name       = $theme->get('Name');
    	$template   = $theme->get('Template');
    	$version    = $theme->get( 'Version' );
    	$compat     = 'false';
    	if ( strtolower( $name ) == 'divi' || strtolower( $name ) == 'extra' || strtolower( $name ) == 'di-basis' ) {
    	    if ( strtolower( $name ) == 'divi' ) {
    		    if ( version_compare( $version, '3.1' ) < 0 ) {
    		        $compat = 'true';
    		    }
    	    } else if ( strtolower( $name ) == 'extra' ) {
    	        if ( version_compare( $version, '2.1' ) < 0 ) {
    	            $compat = 'true';
    	        }
    	    }
    	} else if ( strtolower( $template ) == 'divi' || strtolower( $template ) == 'extra' || strtolower( $template ) == 'di-basis' ) {
    	    if ( strtolower( $template ) == 'divi' ){
    		    $theme      = wp_get_theme('Divi');
    		    $version    = $theme->get( 'Version' );
    			if ( version_compare( $version, '3.1' ) < 0 ) {
    			    $compat = 'true';
    			}
    	    } else if ( strtolower( $template ) == 'extra' ) {
    	        $theme      = wp_get_theme('Extra');
    		    $version    = $theme->get( 'Version' );
    			if ( version_compare( $version, '2.1' ) < 0 ) {
    			     $compat = 'true';
    			}
    	    }
    	} else if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            if ( is_plugin_active( 'divi-builder/divi-builder.php' ) ) {
                if ( ET_BUILDER_PLUGIN_VERSION < '2.1' ) {
                    $compat = 'true';
                }
            }
        } else if ( function_exists( 'is_plugin_active' ) ) {
            if ( is_plugin_active( 'divi-builder/divi-builder.php' ) ) {
                if ( ET_BUILDER_PLUGIN_VERSION < '2.1' ) {
                    $compat = 'true';
                }
            }
        }
        
        if ( $compat == 'true' ) {
            require_once ( plugin_dir_path(__DIR__) . 'src/functions.php' );
		    require_once ( plugin_dir_path(__DIR__) . 'src/class-update.php' );
            add_action( 'wp_enqueue_scripts', 'el_blog_compat_scripts', 999 );
            el_blog_custom_module();
        }
    }
    add_action( 'init', 'el_blog_back_compat_init' );
}

if ( ! function_exists( 'el_blog_compat_scripts' ) ) {
    function el_blog_compat_scripts() {
        $theme      = wp_get_theme();
		$name       = $theme->get('Name');
		$template   = $theme->get('Template');
		
		if ( strtolower( $name ) == 'divi' || strtolower( $name ) == 'extra' || strtolower( $name ) == 'di-basis' || strtolower( $template ) == 'divi' || strtolower( $template ) == 'extra' || strtolower( $template ) == 'di-basis' ) {
	        wp_register_style( 'elicus-blog-css', plugins_url( 'styles/style.min.css', dirname(__DIR__) ), '', ELICUS_BLOG_VERSION );
	        wp_enqueue_style( 'elicus-blog-css' );
		} else {
		    require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		    if ( is_plugin_active( 'divi-builder/divi-builder.php' ) ) {
		        wp_register_style( 'elicus-blog-builder-style', plugins_url( 'styles/style-dbp.min.css', dirname(__DIR__) ), '', ELICUS_BLOG_VERSION );
			    wp_enqueue_style( 'elicus-blog-builder-style' );
		    }
		}
    }
}

if ( ! function_exists( 'el_blog_custom_module' ) ) {
	function el_blog_custom_module(){
		global $pagenow;
		$is_admin = is_admin();
		$action_hook = $is_admin ? 'et_builder_ready' : 'et_builder_ready';
		$required_admin_pages = array( 'edit.php', 'post.php', 'post-new.php', 'admin.php', 'customize.php', 'edit-tags.php', 'admin-ajax.php', 'export.php' ); // list of admin pages where we need to load builder files
		$specific_filter_pages = array( 'edit.php', 'admin.php', 'edit-tags.php' );
		$is_edit_library_page = 'edit.php' === $pagenow && isset( $_GET['post_type'] ) && 'et_pb_layout' === $_GET['post_type'];
		$is_role_editor_page = 'admin.php' === $pagenow && isset( $_GET['page'] ) && 'et_divi_role_editor' === $_GET['page'];
		$is_import_page = 'admin.php' === $pagenow && isset( $_GET['import'] ) && 'wordpress' === $_GET['import'];
		$is_edit_layout_category_page = 'edit-tags.php' === $pagenow && isset( $_GET['taxonomy'] ) && 'layout_category' === $_GET['taxonomy'];

		if ( ! $is_admin || ( $is_admin && in_array( $pagenow, $required_admin_pages ) && ( ! in_array( $pagenow, $specific_filter_pages ) || $is_edit_library_page || $is_role_editor_page || $is_edit_layout_category_page || $is_import_page ) ) ) {
			add_action( $action_hook, 'el_blog_module', 20 );
		}
	}
}

if ( ! function_exists( 'el_blog_module' ) ) {
	function el_blog_module(){
		if( class_exists( 'ET_Builder_Module' ) ) {
		    require_once ( plugin_dir_path(__FILE__) . 'BlogExtras.php' );
		}
	}
}
