<?php

class El_Blog_Module extends ET_Builder_Module {

	public $slug       = 'et_pb_blog_extras';
	public $vb_support = 'partial';

	protected $module_credits = array(
		'module_uri' => 'https://diviextended.com',
		'author'     => 'Elicus Technologies',
		'author_uri' => 'https://elicus.com',
	);

	public function init() {
		$this->name             = esc_html__( 'Divi Blog Extras', 'et_builder' );
		$this->main_css_element = '%%order_class%% .et_pb_post.et_pb_post_extra';
	}
	
	public function get_settings_modal_toggles() {
        return array(
            'general' => array(
                'toggles' => array(
                    'main_content' => array(
                        'title' => esc_html__( 'Content', 'et_builder' ),
                    ),
                    'elements' => array(
                        'title' => esc_html__( 'Elements', 'et_builder' ),
                    ),
                    'pagination' => array(
                        'title'     => esc_html__( 'Pagination', 'et_builder' ),
                        'priority'  => 20,
                    ),
                ),
            ),
            'advanced' => array(
                'toggles' => array(
                    'layout_toggle' => array(
                        'title' => esc_html__( 'Layout', 'et_builder' ),
                    ),
                    'category_toggle' => array(
                        'title' => esc_html__( 'Category', 'et_builder' ),
                    ),
                    'overlay' => array(
                        'title' => esc_html__( 'Overlay', 'et_builder' ),
                    ),
                    'text' => array(
                        'title' => esc_html__( 'Text', 'et_builder' )
                    ),
                ),
            ),
        );
    }
    
    public function get_advanced_fields_config() {
        return array(
            'fonts' => array(
                'header' => array(
                    'label'     => esc_html__( 'Title', 'et_builder' ),
                    'font_size' => array(
                        'type'              => 'range',
                        'dafault'           => '18',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'       => array(
						'main'          => "{$this->main_css_element} h2, {$this->main_css_element} h1, {$this->main_css_element} h3, {$this->main_css_element} h4, {$this->main_css_element} h5, {$this->main_css_element} h6",
						'color'         => "{$this->main_css_element} .entry-title a",
    					'plugin_main'   => "{$this->main_css_element} .entry-title, {$this->main_css_element} .entry-title a",
						'important'     => 'all',
					),
					'header_level'  => array(
						'default'   => 'h2',
					),
				),
				'body'  => array(
				    'label' => esc_html__( 'Body', 'et_builder' ),
					'css'   => array(
						'main'        => "{$this->main_css_element}, %%order_class%%.et_pb_bg_layout_light .et_pb_post .post-content p, %%order_class%%.et_pb_bg_layout_dark .et_pb_post .post-content p",
					    'color'       => "{$this->main_css_element}, {$this->main_css_element} .post-content *",
					    'line_height' => "{$this->main_css_element} .post-content p:not(.post-meta)",
					    'plugin_main' => "{$this->main_css_element}, %%order_class%%.et_pb_bg_layout_light .et_pb_post .post-content p, %%order_class%%.et_pb_bg_layout_dark .et_pb_post .post-content p, %%order_class%%.et_pb_bg_layout_light .et_pb_post a.more-link, %%order_class%%.et_pb_bg_layout_dark .et_pb_post a.more-link",
						'text_shadow' => "{$this->main_css_element}, {$this->main_css_element} .post-content *",
					),
				),
				'meta'  => array(
					'label' => esc_html__( 'Meta', 'et_builder' ),
					'css'   => array(
					    'main'        => "{$this->main_css_element} .post-meta",
					    'plugin_main' => "{$this->main_css_element} .post-meta",
					),
				),
			),
			'background' => array(
			    'css' => array(
				    'main' => "{$this->main_css_element}:not(.el_dbe_box_extended), {$this->main_css_element}:not(.image-background) .post-content, {$this->main_css_element}.el_dbe_block_extended:not(.image-background) .post-meta",
			    )
			),
			'button' => array(
			    'ajax_pagination' => array(
				    'label'             => esc_html__('Ajax Pagination Button', 'et_builder'),
				    'css'               => array(
				        'main' => '%%order_class%% .el-dbe-blog-extra .et_pb_button',
					    'plugin_main' => '%%order_class%% .el-dbe-blog-extra .et_pb_button.el-button'
				    ),
				    'no_rel_attr'       => true,
				    'use_alignment'     => false,
				    'box_shadow'        => false,
				    'depends_on'        => array( 'show_load_more' ),
		            'depends_show_if'   => 'on',
				    'tab_slug'          => 'general',
				    'toggle_slug'       => 'pagination',
			    ),
			),
			'custom_margin_padding' => array(
			    'css' => array(
				    'main' => $this->main_css_element,
			    ),
			),
			'filters'   => false,
			'border'    => array(),
			'max_width' => array(),
			'text'      => array(),
        );
    }
    
    public function get_custom_css_fields_config() {
        return array(
            'title' => array(
				'label'    => esc_html__( 'Title', 'et_builder' ),
				'selector' => '.entry-title',
			),
			'post_meta' => array(
				'label'    => esc_html__( 'Post Meta', 'et_builder' ),
				'selector' => '.post-meta',
			),
			'featured_image' => array(
				'label'    => esc_html__( 'Featured Image', 'et_builder' ),
				'selector' => '.et_pb_image_container',
			),
			'read_more' => array(
				'label'    => esc_html__( 'Read More', 'et_builder' ),
				'selector' => '.more-link',
			),
        );
    }
    
	public function get_fields() {
		return array(
		    
			'blog_layout' => array(
                'label'             => esc_html__( 'Blog Layout', 'et_builder' ),
                'type'              => 'select',
                'option_category'   => 'layout',
                'options'           => array(
                    'grid_extended'         => esc_html__( 'Grid Extended', 'et_builder' ),
                    'box_extended'          => esc_html__( 'Box Extended', 'et_builder' ),
                    'full_width'            => esc_html__( 'Full Width', 'et_builder' ),
                    'block_extended'        => esc_html__( 'Block Extended', 'et_builder' ),
                    'full_width_background' => esc_html__( 'Full Width Background', 'et_builder' ),
                    'classic'               => esc_html__( 'Classic', 'et_builder' ),
                ),
                'default'           => 'grid_extended',
                'tab_slug'          => 'advanced',
			    'toggle_slug'       => 'layout_toggle',
                'description'       => esc_html__( 'Here you can choose the design that you want for the blog.', 'et_builder' ),
            ),
            'posts_number' => array(
                'label'             => esc_html__( 'Posts Number', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'default'           => 10,
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
                'description'       => esc_html__( 'Choose how much posts you would like to display per page.', 'et_builder' ),
            ),
            'offset_number' => array(
                'label'             => esc_html__( 'Offset Number', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'default'           => 0,
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
                'description'       => esc_html__( 'Choose how many posts you would like to offset by.', 'et_builder' ),
            ),
            'post_order'    => array(
                'label'             => esc_html__( 'Order', 'et_builder' ),
                'type'              => 'select',
                'option_category'   => 'configuration',
                'options'           => array(
                    'DESC' => esc_html__( 'DESC', 'et_builder' ),
                    'ASC'  => esc_html__( 'ASC', 'et_builder' ),
                ),
                'default'           => 'DESC',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
            ),
            'post_order_by'    => array(
                'label'             => esc_html__( 'Order by', 'et_builder' ),
                'type'              => 'select',
                'option_category'   => 'configuration',
                'options'           => array(
                    'date'      => esc_html__( 'Date', 'et_builder' ),
                    'modified'  => esc_html__( 'Modified Date', 'et_builder' ),
                    'title'     => esc_html__( 'Title', 'et_builder' ),
                    'name'      => esc_html__( 'Slug', 'et_builder' ),
                    'ID'        => esc_html__( 'ID', 'et_builder' ),
                    'rand'      => esc_html__( 'Random', 'et_builder' ),
                    'none'      => esc_html__( 'None', 'et_builder' ),
                ),
                'default'           => 'date',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
            ),
            'include_categories' => array(
                'label'             => esc_html__( 'Include Categories', 'et_builder' ),
                'renderer'          => 'et_builder_include_categories_option',
                'option_category'   => 'basic_option',
                'renderer_options'  => array(
                    'use_terms' => false,
                ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
                'description'       => esc_html__( 'Choose which categories you would like to include in the feed.', 'et_builder' ),
            ),
            'meta_date' => array(
                'label'             => esc_html__( 'Meta Date Format', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'default'           => 'M j, Y',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
                'description'       => esc_html__( 'If you would like to adjust the date format, input the appropriate PHP date format here.', 'et_builder' ),
            ),
            'show_thumbnail' => array(
                'label'             => esc_html__( 'Show Featured Image', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                    'off' => esc_html__( 'No', 'et_builder' ),
                ),
                'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'This will turn thumbnails on and off.', 'et_builder' ),
            ),
            'image_position' => array(
                'label'             => esc_html__( 'Featured Image Position', 'et_builder' ),
                'type'              => 'select',
                'option_category'   => 'configuration',
                'options'           => array(
                    'top'        => esc_html__( 'Top', 'et_builder' ),
                    'background' => esc_html__( 'Background', 'et_builder' ),
                    'alternate'  => esc_html__( 'Alternate', 'et_builder' ),
                ),
                'show_if'           => array(
                    'blog_layout' => 'block_extended',
                ),
                'show_if_not'       => array(
				    'show_thumbnail' => 'off',
			    ),
			    'default'           => 'top',
                'tab_slug'          => 'advanced',
			    'toggle_slug'       => 'layout_toggle',
                'description'       => esc_html__( 'This will set the thumbnails position.', 'et_builder' ),
            ),
            'show_social_icons' => array(
                'label'             => esc_html__( 'Show Social Icons', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'off' => esc_html__( 'No', 'et_builder' ),
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                ),
                'show_if'           => array(
                    'blog_layout' => 'classic',
                ),
                'default'           => 'off',
                'tab_slug'          => 'advanced',
                'toggle_slug'       => 'layout_toggle',
                'description'        => esc_html__( 'Turn social sharing icons on or off.', 'et_builder' ),
            ),
            'use_overlay' => array(
                'label'             => esc_html__( 'Featured Image Overlay', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'layout',
                'options'           => array(
                    'off' => esc_html__( 'Off', 'et_builder' ),
                    'on'  => esc_html__( 'On', 'et_builder' ),
                ),
                'show_if'           => array(
				    'show_thumbnail' => 'on',
			    ),
			    'default'           => 'off',
                'tab_slug'          => 'advanced',
                'toggle_slug'       => 'overlay',
                'description'       => esc_html__( 'If enabled, an overlay color and icon will be displayed when a visitors hovers over the featured image of a post.', 'et_builder' ),
            ),
            'overlay_icon_color' => array(
                'label'             => esc_html__( 'Overlay Icon Color', 'et_builder' ),
                'type'              => 'color',
                'custom_color'      => true,
                'show_if'           => array(
				    'use_overlay' => 'on',
			    ),
			    'show_if_not'       => array(
				    'show_thumbnail' => 'off',
			    ),
                'tab_slug'          => 'advanced',
                'toggle_slug'       => 'overlay',
                'description'       => esc_html__( 'Here you can define a custom color for the overlay icon', 'et_builder' ),
            ),
            'hover_overlay_color' => array(
                'label'             => esc_html__( 'Hover Overlay Color', 'et_builder' ),
                'type'              => 'color-alpha',
                'custom_color'      => true,
                'show_if'           => array(
				    'use_overlay' => 'on',
			    ),
			    'show_if_not'       => array(
				    'show_thumbnail' => 'off',
			    ),
                'tab_slug'          => 'advanced',
                'toggle_slug'       => 'overlay',
                'description'       => esc_html__( 'Here you can define a custom color for the overlay', 'et_builder' ),
            ),
            'hover_icon' => array(
                'label'                 => esc_html__( 'Hover Icon Picker', 'et_builder' ),
                'type'                  => 'text',
                'option_category'       => 'configuration',
                'class'                 => array( 'et-pb-font-icon' ),
                'renderer'              => 'et_pb_get_font_icon_list',
                'renderer_with_field'   => true,
                'show_if'               => array(
				    'use_overlay' => 'on',
			    ),
			    'show_if_not'           => array(
				    'show_thumbnail' => 'off',
			    ),
                'tab_slug'              => 'advanced',
                'toggle_slug'           => 'overlay',
                'description'           => esc_html__( 'Here you can define a custom icon for the overlay', 'et_builder' ),
            ),
            'show_content' => array(
                'label'             => esc_html__( 'Content', 'et_builder' ),
                'type'              => 'select',
                'option_category'   => 'configuration',
                'options'           => array(
                    'off' => esc_html__( 'Show Excerpt', 'et_builder' ),
                    'on'  => esc_html__( 'Show Content', 'et_builder' ),
                ),
                'default'           => 'off',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
                'description'       => esc_html__( 'Showing the full content will not truncate your posts on the index page. Showing the excerpt will only display your excerpt text.', 'et_builder' ),
            ),
            'excerpt_length' => array(
                'label'             => esc_html__( 'Excerpt Length', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'show_if'           => array(
				    'show_content' => 'off',
			    ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'main_content',
                'description'       => esc_html__( 'Here you can define excerpt length in characters, if 0 no excerpt will be shown.', 'et_builder' ),
            ),
            'show_more' => array(
                'label'             => esc_html__( 'Read More', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'off' => esc_html__( 'Off', 'et_builder' ),
                    'on'  => esc_html__( 'On', 'et_builder' ),
                ),
                'show_if'           => array(
				    'show_content' => 'off',
			    ),
			    'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'Here you can define whether to show "read more" link after the excerpts or not.', 'et_builder' ),
            ),
            'read_more_text' => array(
                'label'             => esc_html__( 'Read More Text', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'show_if'           => array(
				    'show_more' => 'on',
			    ),
                'show_if_not'       => array(
				    'show_content' => 'on',
			    ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'Here you can define "read more" button/link text.', 'et_builder' ),
            ),
            'show_author' => array(
                'label'             => esc_html__( 'Show Author', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                    'off' => esc_html__( 'No', 'et_builder' ),
                ),
                'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'Turn on or off the author link.', 'et_builder' ),
            ),
            'show_date' => array(
                'label'             => esc_html__( 'Show Date', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                    'off' => esc_html__( 'No', 'et_builder' ),
                ),
                'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'Turn the date on or off.', 'et_builder' ),
            ),
            'show_categories' => array(
                'label'             => esc_html__( 'Show Categories', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                    'off' => esc_html__( 'No', 'et_builder' ),
                ),
                'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'Turn the category links on or off.', 'et_builder' ),
            ),
            'category_meta_colors' => array(
                'label'             => esc_html__( 'Pick Colors From Categories', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                    'off' => esc_html__( 'No', 'et_builder' ),
                ),
                'show_if'           => array(
				    'show_categories' => 'on',
			    ),
			    'default'           => 'off',
                'tab_slug'          => 'advanced',
                'toggle_slug'       => 'category_toggle',
                'description'       => esc_html__( 'Use category tag background color from custom field. If defined, it will take precendence over below category colors.', 'et_builder' ),
            ),
            'category_color' => array(
				'label'         => esc_html__( 'Category Color', 'et_builder' ),
				'type'          => 'color',
				'show_if'       => array(
				    'show_categories' => 'on',
			    ),
				'tab_slug'      => 'advanced',
			    'toggle_slug'   => 'category_toggle',
				'description'   => esc_html__( 'Here you can define a custom color for the category text.', 'et_builder' ),
			),
			'category_background_color' => array(
				'label'         => esc_html__( 'Category Background', 'et_builder' ),
				'type'          => 'color-alpha',
				'show_if'       => array(
				    'show_categories' => 'on',
			    ),
				'tab_slug'      => 'advanced',
			    'toggle_slug'   => 'category_toggle',
				'description'   => esc_html__( 'Here you can define a custom color for the category background.', 'et_builder' ),
			),
			'category_hover_color' => array(
				'label'             => esc_html__( 'Category Hover Color', 'et_builder' ),
				'type'              => 'color',
				'show_if'           => array(
				    'show_categories' => 'on',
			    ),
				'tab_slug'          => 'advanced',
			    'toggle_slug'       => 'category_toggle',
				'description'       => esc_html__( 'Here you can define a custom color for the category text on hover.', 'et_builder' ),
			),
			'category_hover_background_color' => array(
				'label'             => esc_html__( 'Category Hover Background', 'et_builder' ),
				'type'              => 'color-alpha',
				'show_if'           => array(
				    'show_categories' => 'on',
			    ),
				'tab_slug'          => 'advanced',
			    'toggle_slug'       => 'category_toggle',
				'description'       => esc_html__( 'Here you can define a custom color for the category background on hover.', 'et_builder' ),
			),
            'show_comments' => array(
                'label'             => esc_html__( 'Show Comment Count', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                    'off' => esc_html__( 'No', 'et_builder' ),
                ),
                'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'elements',
                'description'       => esc_html__( 'Turn comment count on and off.', 'et_builder' ),
            ),
            'show_load_more' => array(
                'label'             => esc_html__( 'Show Pagination', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'off' => esc_html__( 'No', 'et_builder' ),
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                ), 
                'affects'           => array(
                    'custom_ajax_pagination',
	            ),
                'default'           => 'off',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'       => esc_html__( 'Show pagination or not.', 'et_builder' ),
            ),
            'pagination_type' => array(
                'label'             => esc_html__( 'Pagination Type', 'et_builder' ),
                'type'              => 'select',
                'option_category'   => 'layout',
                'options'           => array(
                    'on'    => esc_html__( 'Ajax', 'et_builder' ),
                    'off'   => esc_html__( 'Numbered', 'et_builder' ),
                ), 
                'affects'           => array(
                    'custom_ajax_pagination',
	            ),
                'show_if'           => array(
				    'show_load_more' => 'on',
			    ),
			    'default'           => 'on',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'       => esc_html__( 'Choose pagination type.', 'et_builder' ),
            ),
            'load_more_text' => array(
                'label'             => esc_html__( 'Load More Button', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'show_if'           => array(
				    'pagination_type' => 'on',
			    ),
			    'show_if_not'       => array(
				    'show_load_more' => 'off',
			    ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'       => esc_html__( 'Here you can define load more button text.', 'et_builder' ),
            ),
            'show_less_text' => array(
                'label'             => esc_html__( 'Show Less Button', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'show_if'           => array(
				    'pagination_type' => 'on',
			    ),
			    'show_if_not'       => array(
				    'show_load_more' => 'off',
			    ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'       => esc_html__( 'Here you can define show less button text.', 'et_builder' ),
            ),
            'use_wp_pagenavi' => array(
                'label'             => esc_html__( 'Use WP-PageNavi', 'et_builder' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'options'           => array(
                    'off' => esc_html__( 'No', 'et_builder' ),
                    'on'  => esc_html__( 'Yes', 'et_builder' ),
                ),
                'show_if'           => array(
				    'pagination_type' => 'off',
			    ),
			    'show_if_not'       => array(
				    'show_load_more' => 'off',
			    ),
			    'default'           => 'off',
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'        => esc_html__( 'Use Pagination of WP-PageNavi plugin if installed.', 'et_builder' ),
            ),
            'next_text' => array(
                'label'             => esc_html__( 'Next Link', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'show_if'           => array(
				    'pagination_type' => 'off',
				    'use_wp_pagenavi' => 'off',
			    ),
			    'show_if_not'       => array(
				    'show_load_more' => 'off',
			    ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'       => esc_html__( 'Here you can define Next Link text in numbered pagination.', 'et_builder' ),
            ),
            'prev_text' => array(
                'label'             => esc_html__( 'Prev Link', 'et_builder' ),
                'type'              => 'text',
                'option_category'   => 'configuration',
                'show_if'           => array(
				    'pagination_type' => 'off',
				    'use_wp_pagenavi' => 'off',
			    ),
			    'show_if_not'       => array(
				    'show_load_more' => 'off',
			    ),
                'tab_slug'          => 'general',
                'toggle_slug'       => 'pagination',
                'description'       => esc_html__( 'Here you can define Previous Link text in numbered pagination.', 'et_builder' ),
            ),
            'content_color' => array(
                'label'             => esc_html__( 'Text Color', 'et_builder' ),
                'type'              => 'color',
                'custom_color'      => true,
                'tab_slug'          => 'advanced',
                'toggle_slug'       => 'text',
            ),
            'disabled_on' => array(
                'label'             => esc_html__( 'Disable on', 'et_builder' ),
                'type'              => 'multiple_checkboxes',
                'options'           => array(
                    'phone'   => esc_html__( 'Phone', 'et_builder' ),
                    'tablet'  => esc_html__( 'Tablet', 'et_builder' ),
                    'desktop' => esc_html__( 'Desktop', 'et_builder' ),
                ),
                'additional_att'    => 'disable_on',
                'option_category'   => 'configuration',
                'tab_slug'          => 'custom_css',
			    'toggle_slug'       => 'visibility',
                'description'       => esc_html__( 'This will disable the module on selected devices', 'et_builder' ),
            ),
            'admin_label' => array(
                'label'         => esc_html__( 'Admin Label', 'et_builder' ),
                'type'          => 'text',
                'toggle_slug'   => 'admin_label',
                'description'   => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'et_builder' ),
            ),
            'module_id' => array(
                'label'           => esc_html__( 'CSS ID', 'et_builder' ),
                'type'            => 'text',
                'option_category' => 'configuration',
                'tab_slug'        => 'custom_css',
			    'toggle_slug'     => 'classes',
                'option_class'    => 'et_pb_custom_css_regular',
            ),
            'module_class' => array(
                'label'           => esc_html__( 'CSS Class', 'et_builder' ),
                'type'            => 'text',
                'option_category' => 'configuration',
                'tab_slug'        => 'custom_css',
			    'toggle_slug'     => 'classes',
                'option_class'    => 'et_pb_custom_css_regular',
            ),
            'animation' => array(
				'label'             => esc_html__('Single Post Animation', 'et_builder'),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options' => array(
					'top'       => esc_html__('Top To Bottom', 'et_builder'),
					'left'      => esc_html__('Left To Right', 'et_builder'),
					'right'     => esc_html__('Right To Left', 'et_builder'),
					'bottom'    => esc_html__('Bottom To Top', 'et_builder'),
					'off'       => esc_html__('No Animation', 'et_builder')
				),
				'default'           => 'off',
				'tab_slug'          => 'advanced',
				'toggle_slug'       => 'animation',
				'description'       => esc_html__('This controls the direction of the lazy-loading animation.', 'et_builder')
			),
            
        );
	}

	public function render( $attrs, $content = null, $render_slug ) {
	    
	    global $post;

		// Stored current global post as variable so global $post variable can be restored
		// to its original state when et_pb_blog shortcode ends to avoid incorrect global $post
		// being used on the page (i.e. blog + shop module in backend builder)
		$post_cache = $post;
		
	    /**
		 * Cached $wp_filter so it can be restored at the end of the callback.
		 * This is needed because this callback uses the_content filter / calls a function
		 * which uses the_content filter. WordPress doesn't support nested filter
		 */
		global $wp_filter;
		$wp_filter_cache = $wp_filter;
	    
	    $module_id                      = $this->props['module_id'];
        $module_class                   = $this->props['module_class'];
        $layout                         = $this->props['blog_layout'];
        $posts_number                   = $this->props['posts_number'];
        $include_categories             = $this->props['include_categories'];
        $meta_date                      = $this->props['meta_date'];
        $show_thumbnail                 = $this->props['show_thumbnail'];
        $image_position                 = $this->props['image_position'];
        $show_content                   = $this->props['show_content'];
        $show_more                      = $this->props['show_more'];
        $excerpt_length                 = $this->props['excerpt_length'];
        $read_more_text                 = $this->props['read_more_text'];
        $show_author                    = $this->props['show_author'];
        $show_date                      = $this->props['show_date'];
        $show_categories                = $this->props['show_categories'];
        $category_meta_colors           = $this->props['category_meta_colors'];
        $category_color                 = $this->props['category_color'];
        $category_background            = $this->props['category_background_color'];
        $category_hover_color           = $this->props['category_hover_color'];
        $category_hover_background      = $this->props['category_hover_background_color'];
        $show_comments                  = $this->props['show_comments'];
        $show_load_more                 = $this->props['show_load_more'];
        $pagination_type                = $this->props['pagination_type'];
        $use_wp_pagenavi                = $this->props['use_wp_pagenavi'];
        $prev_text                      = $this->props['prev_text'];
        $next_text                      = $this->props['next_text'];
        $load_more_text                 = $this->props['load_more_text'];
        $show_less_text                 = $this->props['show_less_text'];
        $custom_ajax_pagination         = $this->props['custom_ajax_pagination'];
		$ajax_pagination_icon           = $this->props['ajax_pagination_icon'];
		$ajax_pagination_use_icon       = $this->props['ajax_pagination_use_icon'];
        $offset_number                  = $this->props['offset_number'];
        $post_order                     = $this->props['post_order'];
        $post_order_by                  = $this->props['post_order_by'];
        $show_social_icons              = $this->props['show_social_icons'];
        $overlay_icon_color             = $this->props['overlay_icon_color'];
        $hover_overlay_color            = $this->props['hover_overlay_color'];
        $hover_icon                     = $this->props['hover_icon'];
        $use_overlay                    = $this->props['use_overlay'];
        $content_color                  = $this->props['content_color'];
        $animation                      = $this->props['animation'];
        $header_level                   = $this->props['header_level'];
	    
	    $video_background               = $this->video_background();
		$parallax_image_background      = $this->get_parallax_image_background();
		$processed_header_level         = et_pb_process_header_level( $header_level, 'h2' );
		
		// some themes do not include these styles/scripts so we need to enqueue them in this module to support audio post format
		wp_enqueue_style( 'wp-mediaelement' );
		wp_enqueue_script( 'wp-mediaelement' );

		// include easyPieChart which is required for loading Blog module content via ajax correctly
		wp_enqueue_script( 'easypiechart' );

		// include ET Shortcode scripts
		wp_enqueue_script( 'et-shortcodes-js' );

		// remove all filters from WP audio shortcode to make sure current theme doesn't add any elements into audio module
		remove_all_filters( 'wp_audio_shortcode_library' );
		remove_all_filters( 'wp_audio_shortcode' );
		remove_all_filters( 'wp_audio_shortcode_class' );
    
        if ( '' !== $overlay_icon_color ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .et_overlay:before',
                'declaration' => sprintf(
                    'color: %1$s !important;',
                    esc_html( $overlay_icon_color )
                ),
            ) );
        }

        if ( '' !== $hover_overlay_color ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .et_overlay',
                'declaration' => sprintf(
                    'background-color: %1$s;',
                    esc_html( $hover_overlay_color )
                ),
            ) );
        }
        
        if ( '' !== $content_color ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .post-content p:not(.post-meta)',
                'declaration' => sprintf(
                    'color: %1$s !important;',
                    esc_html( $content_color )
                ),
            ) );
        }
        
        if ( 'on' === $use_overlay ) {
            $data_icon = '' !== $hover_icon
                ? sprintf(
                    ' data-icon="%1$s"',
                    esc_attr( et_pb_process_font_icon( $hover_icon ) )
                )
                : '';

            $overlay_output = sprintf(
                '<span class="et_overlay%1$s"%2$s></span>',
                ( '' !== $hover_icon ? ' et_pb_inline_icon' : '' ),
                $data_icon
            );
        }
        
        if ( 'on' !== $show_content ) {
            if ( $layout == 'classic' ) {
                $excerpt_length = ( '' === $excerpt_length ) ? 600 : esc_attr( $excerpt_length );
            } else {
                $excerpt_length = ( '' === $excerpt_length ) ? 270 : esc_attr( $excerpt_length );
            }
        }
        
        if ( 'on' == $show_more ) {
            $read_more_text = ( '' === $read_more_text ) ? 'Read More' : esc_attr( $read_more_text );
        }
        
        if ( 'on' == $show_load_more ) {
            $load_more_text = ( '' === $load_more_text ) ? 'Load More' : esc_attr( $load_more_text );
            $show_less_text = ( '' === $show_less_text ) ? 'Show Less' : esc_attr( $show_less_text );
        }

        $overlay_class = 'on' === $use_overlay ? ' et_pb_has_overlay' : '';
        
        $args = array( 
            'post_type'         => 'post',
            'posts_per_page'    => intval($posts_number),
            'post_status'       => 'publish',
            'offset'            => 0,
            'orderby'           => 'date',
            'order'             => 'DESC',
        );
        
        if ( is_user_logged_in() ) {
            $args['post_status'] = array( 'publish', 'private' );
        }
        
        if ( '' !== $include_categories ) {
            $args['cat'] = $include_categories;
        }
        
        if ( '' !== $offset_number && ! empty( $offset_number ) ) {
			$args['offset'] = intval( $offset_number );
		}
        
        if( $args['offset'] != '' && $args['posts_per_page'] == -1 ) {
		    $count_posts            = wp_count_posts( 'post', 'readable' );
            $published_posts        = $count_posts->publish;
            $args['posts_per_page'] = $published_posts;
		}
		
		if( $show_load_more == 'on' && $pagination_type == 'off' ){
		    $page           = ( is_front_page() ) ? get_query_var( 'page' ) : get_query_var( 'paged' );
		    $paged          = ( isset( $page ) && $page > 0 )  ? $page : 1;
		    $args['paged']  = $paged;
		    $args['offset'] = ( ( intval( $paged ) - 1 ) * intval( $posts_number ) ) + $args['offset'];
		}
		
		if ( '' !== $post_order_by ) {
			$args['orderby'] = $post_order_by;
		}
		
		if ( '' !== $post_order ) {
			$args['order'] = $post_order;
		}

        if ( is_single() && ! isset( $args['post__not_in'] ) ) {
            $args['post__not_in'] = array( get_the_ID() );
        }
        
        $Query = new WP_Query( $args );
        
        if ( '' !== $offset_number && ! empty( $offset_number ) ) {
            $total = ceil( ( $Query->found_posts - $offset_number ) / $args['posts_per_page'] );
		} else {
		    $total = ceil( ( $Query->found_posts ) / $args['posts_per_page'] );
		}
		
		if ( $Query->have_posts() ) {
		    
		    $counter = 1;
		    
		    $posts = '<div class="el-dbe-blog-extra ' . $layout . '">';
		 
		    while ( $Query->have_posts() ) {
		        $Query->the_post();
		        
		        global $post;
		        
                $postID             = $post->ID;
                $thumb              = '';
                $image_class        = '';
                $date_class         = '';
                $width              = 1080;
				$width              = (int) apply_filters( 'et_pb_blog_image_width', $width );
				$height             = 675;
				$height             = (int) apply_filters( 'et_pb_blog_image_height', $height );
				$classtext          = 'et_pb_post_main_image';
				$titletext          = get_the_title( $postID );
				$thumbnail          = get_thumbnail( $width, $height, $classtext, $titletext, $titletext, false, 'Blogimage' );
				$thumb              = $thumbnail["thumb"];    
                $no_thumb_class     = ( '' === $thumb || 'off' === $show_thumbnail ) ? ' et_pb_no_thumb' : '';
                $layout_class       = ' el_dbe_' . $layout;                
                $animation_class    = ' et-waypoint et_pb_animation_' . $animation;
                
                if ( '' !== $thumb && 'on' === $show_thumbnail ) {
                    if ( $layout == 'block_extended' ) {
                        if ( $image_position != 'alternate' ) {
                            $image_class = ' image-' . $image_position;
                        } else {
                            if ( $counter % 2 != 0 ) {
                                $image_class = ' image-background';
                            } else {
                                $image_class = ' image-top';
                            }
                        }
                    }    
                }
                
                if ( $layout == 'full_width' ) {
                    if ( $show_date == 'off' ){
                        $date_class = ' no_date';
                    }
                }
                
                $post_class = implode( ' ', get_post_class( 'et_pb_post et_pb_post_extra et_pb_text_align_left' . $date_class . $animation_class . $layout_class . $no_thumb_class . $overlay_class . $image_class ) );
                
                $posts  .= '<article id="post-'. $postID .'" class="'. $post_class .'" >';

                if ( file_exists( get_stylesheet_directory() . '/divi-blog-extras/layouts/'.$layout.'.php' ) ) {
                    include get_stylesheet_directory() . '/divi-blog-extras/layouts/'.$layout.'.php';
                } elseif ( file_exists( plugin_dir_path( __FILE__ ) . 'layouts/'.$layout.'.php' ) ) {
                    include ( plugin_dir_path( __FILE__ ) . 'layouts/'.$layout.'.php' );
                }

                $posts  .= '</article> <!-- et_pb_post_extra -->';
                
                $counter++;

		    }
		    
		    if ( 'on' === $show_load_more && ! is_search() ) {
		        
		        /**
		         * Pagination
		         */
		        if ( $pagination_type == 'on' ) {
		            /**
    		         * Ajax Pagination
    		         */
                    if ( $total > 1 ) {
                        $ajax_pagination_data_icon          = ( 'on' == $ajax_pagination_use_icon && '' !== $ajax_pagination_icon && 'on' === $custom_ajax_pagination ) ? sprintf( ' data-icon="%1$s"', esc_attr( et_pb_process_font_icon( $ajax_pagination_icon ) ) ) : '';
	                    $ajax_pagination_custom_icon_class  = ( 'on' == $ajax_pagination_use_icon && '' !== $ajax_pagination_icon && 'on' === $custom_ajax_pagination ) ? ' et_pb_custom_button_icon' : '';
    		            $posts  .= '<div class="ajax-pagination">';
    		            $posts  .= '<a' . $ajax_pagination_data_icon . ' class="et_pb_button el-button el-load-more et-waypoint et_pb_animation_bottom et-animated' . $ajax_pagination_custom_icon_class . '" data-load="1" data-total="' . $total . '">' . $load_more_text . '</a>';
    		            $posts  .= '</div> <!-- ajax-pagination -->';
            		}
		        } else {
		            /**
    		         * Numbered Pagination
    		         */
    		        $posts  .= '<div class="el-blog-pagination">';
    		        
    		        if ( $use_wp_pagenavi == 'on' && function_exists( 'wp_pagenavi' ) ) {
    					$posts .= wp_pagenavi( array(
    						'query' => $Query,
    						'echo'  => false
    					) );
				    } else {
        		        ET_Builder_Element::set_style( $render_slug, array(
                            'selector'    => '%%order_class%% .el-blog-pagination .page-numbers.current',
                            'declaration' => sprintf(
                                'background: %1$s;',
                                esc_html( et_get_option('accent_color', '#2ea3f2') )
                            ),
                        ) );
        		        $big     = 999999999;
        		        $page    = ( is_front_page() ) ? get_query_var( 'page' ) : get_query_var( 'paged' );
                        $posts  .= paginate_links( array(
                                    'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                                	'format'    => '?paged=%#%',
                                	'type'      => 'list',
                                	'prev_text' => ( $prev_text ) ? $prev_text : '« Previous',
                                	'next_text' => ( $next_text ) ? $next_text : 'Next »',
                                	'current'   => max( 1, $page ),
                                	'total'     => $total,
                        ) );
				    }
				    
				    $posts  .= '</div><!-- el-blog-pagination -->';
		        }
		        
		    }
		    
		    $posts  .= '</div> <!-- el-dbe-blog-extra -->';
		    
		    /**
	         * For Ajax Pagination
	         */
		    if ( 'on' === $show_load_more && $pagination_type == 'on' && ! is_search() ) {
		        $posts  .= '<div class="el-blog-params">';
                $posts  .= '<input type="hidden"
                    		    render_slug="' . $render_slug . '"
                                layout="' . $layout . '"
                                posts_number="' . $posts_number . '"
                                include_categories="' . $include_categories . '"
                                meta_date="' . $meta_date . '"
                                show_thumbnail="' . $show_thumbnail . '"
                                image_position="' . $image_position . '"
                                show_content="' . $show_content . '"
                                show_more="' . $show_more . '"
                                excerpt_length="' . $excerpt_length . '"
                                read_more_text="' . $read_more_text . '"
                                show_author="' . $show_author . '"
                                show_date="' . $show_date . '"
                                show_categories="' . $show_categories . '"
                                category_meta_colors="' . $category_meta_colors . '"
                                show_comments="' . $show_comments . '"
                                show_load_more="' . $show_load_more . '"
                                pagination_type="' . $pagination_type . '"
                                prev_text="' . $prev_text . '"
                                next_text="' . $next_text . '"
                                load_more_text="' . $load_more_text . '"
                                show_less_text="' . $show_less_text . '"
                                offset_number="' . $offset_number . '"
                                post_order="' . $post_order . '"
                                post_order_by="' . $post_order_by . '"
                                show_social_icons="' . $show_social_icons . '"
                                overlay_icon_color="' . $overlay_icon_color . '"
                                hover_overlay_color="' . $hover_overlay_color . '"
                                hover_icon="' . esc_attr( et_pb_process_font_icon( $hover_icon ) ) . '"
                                use_overlay="' . $use_overlay . '"
                                content_color="' . $content_color . '"
                                animation="' . $animation . '"
                                ajax_pagination_use_icon="' . $ajax_pagination_use_icon . '"
                                ajax_pagination_icon="' . $ajax_pagination_icon . '"
                                custom_ajax_pagination="' . $custom_ajax_pagination . '"
                                processed_header_level="' . $processed_header_level .'"
                                />';
                $posts  .= '</div> <!-- el-blog-params -->';
		    }
		    
		    wp_reset_postdata();
		    
        } else {
            $theme = wp_get_theme();
            if( strtolower( $theme->get( 'Name' ) ) != 'divi' || strtolower( $theme->get( 'Name' ) ) != 'extra' ) {
                $txtdomain = 'divi';
            }else{
                $txtdomain = strtolower( $theme->get( 'Name' ) );
            }
            $posts = '<div class="entry">
	                    <h1>'. esc_html_e( 'No Results Found', $txtdomain ) .'</h1>
	                    <p>'. esc_html_e( 'The page you requested could not be found. Try refining your search, or use the navigation above to locate the post.', $txtdomain ) .'</p>
                    </div>';
        }
        
        $this->remove_classname( array(
			$render_slug,
		) );
		
        $output = sprintf(
            '<div%2$s class="et_pb_posts et_pb_bg_layout_light %3$s%4$s">
				%1$s
			</div> <!-- et_pb_posts -->',
			$posts,
			( '' !== $module_id ? sprintf( ' id="%1$s"', esc_attr( $module_id ) ) : '' ),
            $this->module_classname( $render_slug ),
            ( '' !== $module_class ? sprintf( ' %1$s', esc_attr( $module_class ) ) : '' )
        );

        // Restore $wp_filter
        $wp_filter = $wp_filter_cache;
        unset( $wp_filter_cache );
        
        // Restore global $post into its original state when et_pb_blog shortcode ends to avoid
		// the rest of the page uses incorrect global $post variable
		$post = $post_cache;
		
        return $output;
	    
	}
	
	public function process_box_shadow( $function_name ) {
		/**
		 * @var ET_Builder_Module_Field_BoxShadow $boxShadow
		 */
		$boxShadow = ET_Builder_Module_Fields_Factory::get( 'BoxShadow' );
		$selector   = '.' . self::get_module_order_class( $function_name );
        $selector  .= ' .et_pb_post_extra.et_pb_post';

		self::set_style( $function_name, $boxShadow->get_style( $selector, $this->props ) );
	}
	
	/**
	 * Since the styling file is not updated until the author updates the page/post,
	 * we should keep the drop shadow visible.
	 *
	 * @param string $functions_name
	 *
	 * @return string
	 */
	private function drop_shadow_back_compatibility( $functions_name ) {
		$utils = ET_Core_Data_Utils::instance();
		$atts  = $this->props;

		if (
			version_compare( $utils->array_get( $atts, '_builder_version', '3.0.93' ), '3.0.94', 'lt' )
			&&
			'on' === $utils->array_get( $atts, 'use_dropshadow' )
		) {
			$class = self::get_module_order_class( $functions_name );
			
			return sprintf(
				'<style>%1$s</style>',
				sprintf( '.%1$s  .et_pb_post_extra.et_pb_post { box-shadow: 0 1px 5px rgba(0,0,0,.1) }', esc_html( $class ) )
			);
		}

		return '';
	}
}

new El_Blog_Module;
