/**
 * Plugin Name: Divi Bars
 * Plugin URL: https://divilife.com/
 * Description: Create slide-in promo bars using the Divi Builder.
 * Version: 1.0
 * Author: Divi Life — Tim Strifler
 * Author URI: https://divilife.com
*/
;(function ( $, window, document, undefined ) {
  'use strict';
  
    $.fn.mainDiviBars = function( options ) {
		
		var divibar_body
		, divibar
		, idx_divibar
		, divi_divibar_container_selector
		, $divibar = this
		, contentLengthcache
		, divibarHeightCache
		, diviMobile
		, diviMobileCache
		, themesBreakpoint = { Divi:980, Extra:1024 }
		, styleTagID = 'divi-bars-styles'
		, vw
		, fixedElements
		, scrollCheck;
		
		if (typeof options == 'function') {
			options = { success: options };
		}
		else if ( options === undefined ) {
			options = {};
		}
		
		// Trying to prevent others plugins override Divi Bars styles
		$( '<style id="' + styleTagID + '"></style>' ).appendTo( 'head' );
		
		if ( $('div.divibars-container').length ) {
			
			// Viewing from a non-large device?
			diviMobile = diviMobileCache = isDiviMobile();
			
			var divibar_container = $( 'div.divibars-container' )
			, container = $( 'div#page-container' )
			, positionTimer = 0
			, removeMonarchTimer = 0;
			
			var cacheHtmlMarginTop = parseInt( $('html').css('margin-top') );
			if ( cacheHtmlMarginTop <= 0 ) {
				
				cacheHtmlMarginTop = 0;
			}
			
			var cacheBodyPaddingTop = parseInt( $('body').css('padding-top') );
			if ( cacheBodyPaddingTop <= 0 ) {
				
				cacheBodyPaddingTop = 0;
			}
			
			var cacheBodyPaddingBottom = parseInt( $('body').css('padding-bottom') );
			if ( cacheBodyPaddingBottom <= 0 ) {
				
				cacheBodyPaddingBottom = 0;
			}
			
			var cacheTopHeaderTop = parseInt( $('#top-header').css('top') );
			if ( cacheTopHeaderTop <= 0 ) {
				
				cacheTopHeaderTop = 0;
			}
			
			var cacheMainHeaderTop = parseInt( $('#main-header').css('top') );
			if ( cacheMainHeaderTop <= 0 ) {
				
				cacheMainHeaderTop = 0;
			}
			
			var bodyHtmlStyleCache = $( "body,html" ).attr('style');
			
			// Save ID and Class attrs from fixed/absolute elements
			fixedElements = getFlyingElements();
			
			// Remove any duplicated divibar
			$( divibar_container ).each(function () {
				$('[id="' + this.id + '"]:gt(0)').remove();
			});
			
			$('body [id^="divibars_"]').on('click touch tap', function (e) {
				
				var divibarArr = $(this).attr('id').split('_')
				, divibar_id = divibarArr[3]
				, cookieName = 'divibar' + divibar_id;
				
				eraseCookie( cookieName );
				
				showDivibar( divibar_id );
				
				e.preventDefault();
			});
			
			$('body [rel^="unique_divibars_"]').on('click touch tap', function (e) {
				
				var divibarArr = $(this).attr('rel').split('_')
				, divibar_id = divibarArr[4]
				, cookieName = 'divibar' + divibar_id;
				
				eraseCookie( cookieName );
				
				showDivibar( divibar_id );
				
				e.preventDefault();
			});
			
			$('body [class*="dividivibar-"], body [class*="divibar-"]').on('click touch tap', function (e) {
				
				var divibarArr = $(this).attr('class').split(' ');
				
				$( divibarArr ).each(function( index,value ) {
					
					idx_divibar = value.indexOf('divibar');
					
					if ( idx_divibar !== -1 ) {
						
						var idx_divibarArr = value.split('-');
						
						if ( idx_divibarArr.length > 1 ) {
							
							var divibar_id = idx_divibarArr[1]
							, cookieName = 'divibar' + divibar_id;
							
							eraseCookie( cookieName );
							
							showDivibar( divibar_id );
						}
					}
				});
			});
			
			if (typeof divibars_with_css_trigger !== 'undefined') {
				
				if ( $( divibars_with_css_trigger ).length > 0 ) {
					
					$.each( divibars_with_css_trigger, function( divibar_id, selector ) {
						
						$( selector ).on('click touch tap', function (e) {
							
							var cookieName = 'divibar' + divibar_id;
							
							eraseCookie( cookieName );
							
							showDivibar( divibar_id );
							
							e.preventDefault();
						});
					});
				}
			}
			
			if (typeof divibars_with_automatic_trigger !== 'undefined') {
				
				if ( $( divibars_with_automatic_trigger ).length > 0 ) {
					
					$.each( divibars_with_automatic_trigger, function( divibar_id, at_settings ) {
						
						var at_settings_parsed = jQuery.parseJSON( at_settings )
						, at_type_value = at_settings_parsed.at_type
						, at_onceperload = at_settings_parsed.at_onceperload;
						
						if ( at_onceperload == 1 ) {
							
							showdivibarOnce( divibar_id );
						}
						
						if ( at_type_value == 'divibar-timed' ) {
							
							var time_delayed = at_settings_parsed.at_value * 1000;
							
							setTimeout( function() {
								
								showDivibar( divibar_id );
								
							}, time_delayed);
						}
						
						
						if ( at_type_value == 'divibar-scroll' ) {
							
							var divibarScroll = at_settings_parsed.at_value, refScroll;
							
							if ( divibarScroll.indexOf('%') || divibarScroll.indexOf('px') ) {
								
								if ( divibarScroll.indexOf('%') ) {
									
									divibarScroll = divibarScroll.replace(/%/g, '');
									refScroll = '%';
								}
								
								if ( divibarScroll.indexOf('px') ) {
									
									divibarScroll = divibarScroll.replace(/px/g, '');
									refScroll = 'px';
								}
								
								divibarScroll = divibarScroll.split(':');
								
								var divibarScrollFrom = divibarScroll[0]
								, divibarScrollTo = divibarScroll[1];
								
								$(window).scroll(function(e) {
								
									var s = getScrollTop()
									, d = $(document).height()
									, c = $(window).height()
									, wScroll;
									
									if ( refScroll == '%' ) {
										
										wScroll = (s / (d-c)) * 100;
									
									} else if ( refScroll == 'px' ) {
										
										wScroll = s;
										
									} else {
										
										return;
									}
									
									if ( divibarScrollFrom > 0 && divibarScrollTo > 0 ) {
										
										if ( divibarScrollFrom <= wScroll && divibarScrollTo >= wScroll ) {
											
											if ( !isActiveDivibar( divibar_id ) ) {
												
												showDivibar( divibar_id );
											}
										}
										else if ( isActiveDivibar( divibar_id ) ) {
											
											closeActiveDivibar( divibar_id );
										}
									}
									
									if ( divibarScrollFrom > 0 && divibarScrollTo == '' ) {
										
										if ( divibarScrollFrom <= wScroll ) {
											
											if ( !isActiveDivibar( divibar_id ) ) {
												
												showDivibar( divibar_id );
											}
										}
										else if ( isActiveDivibar( divibar_id ) ) {
											
											closeActiveDivibar( divibar_id );
										}
									}
									
									if ( divibarScrollFrom == '' && divibarScrollTo > 0 ) {
										
										if ( divibarScrollTo >= wScroll ) {
											
											if ( !isActiveDivibar( divibar_id ) ) {
												
												showDivibar( divibar_id );
											}
										}
										else if ( isActiveDivibar( divibar_id ) ) {
										
											closeActiveDivibar( divibar_id );
										}
									}
								});
							}
						}
						
						
						if ( at_type_value == 'divibar-exit' ) {
							
							$.exitIntent('enable', { 'sensitivity': 100 });
							
							$(document).bind('exitintent',
								function() {
									
									if ( !isActiveDivibar( divibar_id ) ) {
										
										showDivibar( divibar_id );
									}
								});
						}
					});
				}
			}
			
			
			$('.nav a, .mobile_nav a').each(function( index,value ) {
				
				var href = $( value ).attr('href');
				
				if ( href !== undefined ) {
				
					idx_divibar = href.indexOf('divibar');
					
					if ( idx_divibar !== -1 ) {
						
						var idx_divibarArr = href.split('-');
						
						if ( idx_divibarArr.length > 1 ) {
							
							var divibar_id = idx_divibarArr[1];
							
							$(this).attr('data-divibarid', divibar_id);
							
							$(this).on('click touch tap', function () {
								
								divibar_id = $(this).data('divibarid');
								
								showDivibar( divibar_id );
							});
						}
					}
				}
			});
			
			
			function getFlyingElements() {
				
				var elemData = {}
				, height
				, totalHeight = 0
				, allElems
				, attr
				, lastElemHeight = 0
				, defaultElems = '#wpadminbar,#top-header';
				
				if ( $( 'body' ).hasClass('et_extra') ) { /* Extra theme support */
					
					defaultElems += ',#main-header-wrapper';
					
				} else {
					
					defaultElems += ',#main-header';
				}
				
				allElems = defaultElems;
				
				// Add custom elements (Divi Bars Settings)
				if ( divibars_settings  !== undefined && divibars_settings['dib_custom_elems'] !== undefined && divibars_settings['dib_custom_elems'] != '' ) {
					
					allElems = allElems + ',' + divibars_settings['dib_custom_elems'];
				}
				
				/*
				if ( !diviMobile ) {
					
					allElems = 'div,header,footer,nav' + allElems;
				}
				*/
				
				allElems = allElems.split( ',' );
				
				fixedElements = [];
				
				$.each( allElems, function( index, value ) {
					
					if ( $( this ).length > 0 ) {
						
						if ( !$( this ).hasClass('divibars') ) {
							
							elemData['id'] = ( $( this ).attr('id') !== undefined ) ? $( this ).attr('id') : '';
							elemData['class'] = ( $( this ).attr('class') !== undefined ) ? $( this ).attr('class') : '';
							elemData['css_height'] = getElemHeight( $( this ) );
							elemData['css_top'] = parseInt( $(this).css('top') );
							elemData['css_position'] = $( this ).css('position');
							elemData['lastElemHeight'] = lastElemHeight;
							
							if ( elemData['css_position'] != 'fixed' && elemData['css_position'] != 'absolute' ) {
								
								elemData = fixElementsPositionTop( elemData );
							}
							
							if (
								(
									elemData['css_position'] == 'fixed' 
									&& $( this ).css('display') != 'none' 
									&& $( this ).css('visibility') != 'hidden' 
									&& elemData['css_top'] >= 0
								)
								|| 
								(
									diviMobile
									&& elemData['css_position'] == 'absolute' 
									&& $( this ).css('display') != 'none' 
									&& $( this ).css('visibility') != 'hidden' 
									&& elemData['css_top'] >= 0
								)
								) {
								
								if ( diviMobile && elemData['css_position'] == 'absolute' ) {
									
									$( this ).attr('data-position', 'absolute');
								}
								else if ( !diviMobile && elemData['css_position'] == 'fixed' ) {
									
									$( this ).attr('data-position', '');
								}
								
								if ( ( elemData['id'] != '' ) 
									|| ( elemData['class'] != '' ) ) {
									
									fixedElements[ elemData['css_top'] ] = [];
									fixedElements[ elemData['css_top'] ]['id'] = elemData['id'];
									fixedElements[ elemData['css_top'] ]['class'] = elemData['class'];
									fixedElements[ elemData['css_top'] ]['css_top'] = elemData['css_top']
									fixedElements[ elemData['css_top'] ]['css_height'] = elemData['css_height'];
									fixedElements[ elemData['css_top'] ]['css_position'] = elemData['css_position'];
									
									totalHeight = ( totalHeight + elemData['css_height'] );
									
									lastElemHeight = elemData['css_height'];
								}
							}
						}
					}
					
				});
				
				fixedElements['totalHeight'] = totalHeight;
				
				return fixedElements;
			}
			
			
			function fixElementsPositionTop( elemData ) {
				
				var selector
				, newCssTop
				, divibar_id = getActiveDivibar()
				, divibar_selector = '#divibar-' + divibar_id
				, divibarHeight = $( divibar_selector ).find('.divibars-body').height()
				
				if ( elemData['id'] != '' ) {
					
					selector = '#' + elemData['id'];
				}
				else if ( elemData['class'] != '' ) {
					
					selector = '.' + elemData['class'];
					
				}
				else {
					
					return false;
				}
				
				newCssTop = divibarHeight + elemData['lastElemHeight'];
				
				addStyles( selector, 'width:100% !important;' );
				addStyles( selector, 'top:' + newCssTop + 'px !important;' );
				addStyles( selector, 'position:fixed !important;' );
				
				elemData['css_top'] = newCssTop;
				elemData['css_position'] = 'fixed';
				
				return elemData;
			}
			
			
			var fixedElementsScrollHandler = function( fixedElements ) {
				
				if ( ! $( "html,body" ).hasClass('divibar-open') ) {
					
					return;
				}
				
				autoPositionFixedElements( fixedElements );
			}
			
			
			function autoPositionFixedElements( fixedElements ) {
				
				var scroll = getScrollTop()
					, selector
					, divibar_id = getActiveDivibar()
					, divibar_selector = '#divibar-' + divibar_id
					, divibar = $( divibar_selector )
					, divibarHeight = $( divibar_selector ).find('.divibars-body').height()
					, currentPosition
					, currentPositionTop
					, position
					, dataPosition
					, divibarScreenfixed = divibar.data('screenfixed');
					
				if ( fixedElements[0]['id'].length ) {
					
					if ( fixedElements[0]['id'] != '' ) {
						
						selector = '#' + fixedElements[0]['id'];
						
					} else if ( fixedElements[0]['class'] != '' ) {
						
						selector = '.' + fixedElements[0]['class'];
						
					} else {
						
						return false;
					}
				}
				
				dataPosition = $( selector ).attr('data-position');
				
				if ( dataPosition != 'absolute' ) {
					
					if ( !divibarScreenfixed ) {
						
						divibarHeight = divibarHeight - fixedElements['totalHeight'];
					}
					
					if ( dataPosition != 'fixed' 
						&& scroll > divibarHeight ) {
						
						scrollCheck = true;
						
						whileScrollingUpdateFixedElementsPosition( 'fixed' );
						
						$( selector ).attr('data-position', 'fixed');
								
					} else if ( dataPosition == 'fixed' 
						&& scroll < divibarHeight ) {
							
						scrollCheck = false;
						
						whileScrollingUpdateFixedElementsPosition( 'absolute' );
						
						$( selector ).attr('data-position', '');
					}
				}
			}
			
			
			function whileScrollingUpdateFixedElementsPosition( position ) {
				
				var selector
				, positionTop
				, divibar_id = getActiveDivibar()
				, divibar_selector = '#divibar-' + divibar_id
				, divibar = $( divibar_selector )
				, divibarHeight = divibar.find('.divibars-body').height()
				, lastPosition
				, elemHeight
				, lastElemHeight = 0
				, currentPosition
				, keepElementPosition
				, screenfixed = divibar.data('screenfixed');
				
				lastPosition = divibarHeight;
				
				$.each( fixedElements, function( index, value ) {
					
					if ( Array.isArray( value ) ) {
						
						if ( value['id'] != '' ) {
							
							selector = '#' + value['id'];
							
						} else if ( value['class'] != '' ) {
							
							selector = '.' + value['class'];
							
						} else {
							
							return true;
						}
						
						keepElementPosition = $( selector ).attr('data-position') == 'absolute' ? true : false;
						
						if ( scrollCheck ) {
							
							lastPosition = lastPosition + lastElemHeight;
							
							positionTop = lastPosition;
							
							if ( !keepElementPosition ) {
								
								$( selector ).attr('data-position', '');
							}
						}
						else if ( !scrollCheck ) {
							
							currentPosition = parseInt( $( selector ).css('top') );
							
							lastPosition = lastPosition - lastElemHeight;
							
							positionTop = currentPosition - divibarHeight;
						}
						
						addStyles( selector, 'top:' + positionTop + 'px !important;' );
						
						if ( !keepElementPosition ) {
							
							$( selector ).removeClass( 'divibar-elem-transition-top' );
							
							
							if ( position != null ) {
								
								addStyles( selector, 'position:' + position + ' !important;' );
							}
						}
						
						if ( diviMobile ) {
							
							// Except divibar, we don't want other elements position fixed in mobile while divibar is active
							if ( divibar_selector != selector ) {
								
								addStyles( selector, 'position:absolute !important;' );
							}
						}
						
						elemHeight = value['css_height'];
						
						lastElemHeight = elemHeight;
					}
					
				});
			}
			
			
			function toggleDivibar( divibar_id ) {
				
				var divibar_selector = '#divibar-' + divibar_id
				, divibar_cache_selector = '#divibar-' + divibar_id
				, divibar_container = '#divi-divibars-container-' + divibar_id
				, divibar = $('body').find( divibar_cache_selector )
				, oid = divibar.attr('id')
				, isMobile = divibar.attr('data-ismobile');
				
				var displayonceperload = divibar.data('displayonceperload')
				, preventOpen = divibar.attr('data-preventopen');
				
				var placement = divibar.data('placement')
				, plSign = '+'
				, pushpage = divibar.data('pushpage')
				, screenfixed = divibar.data('screenfixed');
				
				var cookieName = 'divibar' + divibar_id
				, cookieDays = divibar.data('cookie');
				
				var topHeader_selector = '#top-header'
				, topHeaderHeight = $( topHeader_selector ).height();
				
				var divibarBody = $( divibar ).find('.divibars-content-inner')
				, divibarHeight = divibarBody.height()
				, mainHeaderTop = ( divibarHeight + topHeaderHeight ) + 'px'
				, bodyPaddingTopDivibar = ( divibarHeight - cacheHtmlMarginTop ) + 'px';
				
				var pageContainer = $( '#page-container' );
				
				var options = [];
				options['placement'] = placement;
				options['screenfixed'] = screenfixed;
				options['bodyPaddingTopDivibar'] = bodyPaddingTopDivibar;
				options['divibarHeight'] = divibarHeight;
					
				if ( placement == 'top' ) {
					
					contentLengthcache = $( divibar_selector ).text().length;
				}
				
				if ( readCookie( cookieName ) ) {
					
					return;
				}
				
				if ( !screenfixed ) {
					
					$( divibar ).css( 'position', 'fixed' );
				}
				
				if ( screenfixed ) {
				
					window.scrollTo(0,0);
				}
				
				
				if ( $( divibar ).hasClass('open') ) { // Closing divibar
				
					setTimeout( function() {
						
						$( divibar ).removeClass( 'divibars-opened' );
						
						if ( cookieDays > 0 ) {
							
							createCookie( cookieName, 'true', cookieDays );
						}
						
						$( divibar ).removeClass('open');
						$( divibar ).addClass('close');
						
						if ( pushpage ) {
							
							pushBody( options, 'close' );
						}
						
						$( divibar ).transition({
							height: 0,
							easing: 'linear',
							duration: 400,
							complete: function() {
							
								$( divibar ).removeClass( 'close' );
								$( "html,body" ).removeClass('divibar-open');
								
								if ( displayonceperload ) {
									
									$( divibar_container ).remove();
								}
								else {
									
									dibTogglePlayableTags( '#divibar-' + divibar_id );
								}
								
								// $( divibar ).removeAttr('style');
								
								if ( !isActiveDivibar() ) {
									
									if ( pageContainer.length ) {
										
										$( "#page-container .container" ).css('z-index','1');
										$( "#page-container #main-header" ).css('z-index','99989');
									}
									
									$( "#sidebar-divibar" ).css('z-index','-15');
								}
								
								$( "#sidebar-divibar" ).removeClass('sidebar-divibar-bottom');
								
								if ( screenfixed ) {
									
									if ( typeof bodyHtmlStyleCache != 'undefined' && bodyHtmlStyleCache != '' ) {
										
										$( "body,html" ).attr( 'style', bodyHtmlStyleCache );
									}
									else {
										
										$( "body,html" ).removeAttr( 'style' );
									}
									
									$( "#sidebar-divibar" ).css( 'position', 'absolute' );
									
									affixFixedElements( divibarHeight, 'close' );
								}
								
								$( divibar ).find( ".divibars-close-container" ).removeClass( 'dibShow' );
								
								setTimeout( function() {
									
									$( '#' + styleTagID ).empty();
									
								}, 200);
							}
						 });
					 
					 }, 100);
				}
				else if( !$( divibar ).hasClass('close') && !preventOpen ) { // Opening divibar
				
					if ( !screenfixed ) {
						
						if ( placement ) {
							
							$( divibar ).css( placement, plSign + '0' );
						}
					}
					
					if ( displayonceperload ) {
						
						divibar.attr('data-preventopen', 1);
					}
					
					divibar.attr('data-scrolltop', getScrollTop() );
					
					$( "html,body" ).addClass('divibar-open');
					
					if ( pageContainer.length ) {
						
						$( "#page-container .container" ).css('z-index','0');
					}
					
					$( divibar ).css('height', 0);
					
					setTimeout( function() {
						
						$( "#sidebar-divibar" ).css('z-index','16777271');
						
						$( divibar ).addClass('open');
						
						$( divibar ).transition({
							height: divibarHeight + 'px',
							complete: function() {
								
								if ( placement == 'top' ) {
									
									divibarHeightCache = getElemHeight( $( divibar_selector ) );
								}
								
								$( divibar ).addClass( 'divibars-opened' );
								$( divibar ).find( ".divibars-close-container" ).addClass( 'dibShow' );
							}
						});
						
						if ( pushpage ) {
							
							pushBody( options, 'open' );
							
							$(window).scroll( fixedElementsScrollHandler.bind( null, fixedElements ) );
							
							if ( screenfixed ) {
								
								$( "body,html" ).attr('style', 'margin:0 !important; padding:0 !important');
								$( "#sidebar-divibar" ).css( 'position', 'relative' );
								$( divibar ).css( 'position', 'relative' );
								
								affixFixedElements( divibarHeight, 'open' );
							}
						}
						
						if ( divibar.attr('data-bgcolor') != "") {
							$( divibar_cache_selector ).css( { 'background-color': divibar.attr('data-bgcolor') } );
						}
						
						if ( divibar.attr('data-fontcolor') != "") {
							$( divibar_cache_selector ).css( 'color', divibar.attr('data-fontcolor') );
						}
						
					}, 200);
				}
			}
			
			
			function getScrollTop() {
				
				if ( typeof pageYOffset!= 'undefined' ) {
					
					// most browsers except IE before #9
					return pageYOffset;
				}
				else {
					
					var B = document.body; // IE 'quirks'
					var D = document.documentElement; // IE with doctype
					D = ( D.clientHeight ) ? D: B;
					
					return D.scrollTop;
				}
			}
			
			function showDivibar( divibar_id ) {
				
				if ( !isInt( divibar_id ) )
					return;
				
				divi_divibar_container_selector = '#divi-divibars-container-' + divibar_id;
				
				if ( $( divi_divibar_container_selector ).length ) {
				
					divibar_body = $( divi_divibar_container_selector ).find( '.divibars' );
					
					toggleSrcInPlayableTags( divibar_body );
					
					toggleDivibar( divibar_id );
				}
			}
			
			function showdivibarOnce( divibar_id ) {
				
				if ( !isInt( divibar_id ) )
					return;
				
				divibar = '#divibar-' + divibar_id;
				
				$( divibar ).attr( 'data-displayonceperload', 1 );
			}
			
			function toggleSrcInPlayableTags( str ) {
				
				str.find("iframe").each(function() { 
					var src = $(this).data('src');
					$(this).attr('src', src);  
				});
				
				return str;
			}
			
			$('body').on('click touch tap', '.divibars-close, .divibars-close span, .close-divibar', function(e) {
				
				if ( e.target !== e.currentTarget ) return;
				
				closeDivibar(this);
			});
			
			function closeActiveDivibar( divibar_id ) {
				
				// find active divibar
				var divibar = $( 'body' ).find( '.divibars.open' );
				var displayonceperload = divibar.data('displayonceperload');
				
				if ( divibar.length ) {
					
					if ( divibar_id == null ) {
						
						var divibarArr = divibar.attr('id').split('-');
						divibar_id = divibarArr[1];
					}
					
					showDivibar( divibar_id );
				}
			}
			
			function closeDivibar( elem, divibar_id ) {
				
				if ( divibar_id == null ) {
					
					var divibarArr = $( elem ).parents( '.divibars' ).attr('id').split('-');
					divibar_id = divibarArr[1];
				}
				
				showDivibar( divibar_id );
			}
			
			function getActiveDivibar() {
				
				var divibar = null
				, divibar_id = null
				, elemID = null
				, placement = null;
				
				// find active divibar only in top
				$('.divibars.open').each(function( index, el ) {
					
					placement = $(this).data('placement');
					
					if ( placement == 'top' ) {
						
						elemID = $(this).attr('id');
						
						divibar = $( '#' + elemID );
					}
					
				});
				
				if ( !divibar ) {
					
					divibar = $( 'body' ).find( '.divibars.close' );
				}
				
				if ( divibar.length ) {
					
					var divibarArr = divibar.attr('id').split('-');
					var divibar_id = divibarArr[1];
				}
				
				return divibar_id;
			}
			
			function isOpeningDivibar( divibar_id ) {
				
				if ( !divibar_id ) {
					
					return null;
				}
				
				var divibar = $( '#divibar-' + divibar_id );
				
				if ( $( divibar ).css('opacity') < 1 ) {
					
					return true;
				}
				
				return false;
			}
			
			function isClosingdivibar( divibar_id ) {
				
				if ( !divibar_id ) {
					
					return null;
				}
				
				var divibar = $( '#divibar-' + divibar_id );
				
				if ( $( divibar ).hasClass('close') ) {
					
					return false;
				}
				
				return true;
			}
			
			function isActiveDivibar( divibar_id ) {
				
				if ( !divibar_id ) {
					
					var divibar = $( '.divibars.open' );
				}
				else {
					
					var divibar = $( '#divibar-' + divibar_id );
				}
				
				if ( $( divibar ).hasClass('open') ) {
					
					return true;
				}
				
				return false;
			}
			
			function isInt(value) {
				var x;
				return isNaN(value) ? !1 : (x = parseFloat(value), (0 | x) === x);
			}
			
			
			function pushBody( options, status, onlyPushBody ) {
				
				var placement = options['placement']
				, screenfixed = options['screenfixed']
				, bodyPaddingTopDivibar = options['bodyPaddingTopDivibar']
				, divibarHeight = options['divibarHeight'];
				
				if ( status == 'close' ) {
					
					$( "#sidebar-divibar" ).css('z-index','1');
					
					if ( placement == 'bottom' ) {
						
						if ( !screenfixed ) {
						
							$( 'body' ).transition({ paddingBottom: cacheBodyPaddingBottom + 'px' });
						}
					}
						
					if ( placement == 'top' ) {
						
						$( 'body' ).transition({ paddingTop: cacheBodyPaddingTop + 'px' });
						
						$( '#page-container' ).removeAttr('style');
						
						if ( !onlyPushBody ) {
							
							updateFixedElementsPosition( 'close' );
						}
					}
					
				} else if ( status == 'open' ) {
				
					if ( placement == 'bottom' ) {
						
						if ( !screenfixed ) {
						
							$( 'body' ).transition({ paddingBottom: divibarHeight + 'px' });
						}
					}
					
					if ( placement == 'top' ) {
						
						$( '#page-container' ).transition({ paddingTop: fixedElements['totalHeight'] });
						
						if ( !screenfixed ) {
						
							$( 'body' ).transition({ paddingTop: bodyPaddingTopDivibar });
						}
						
						if ( !onlyPushBody ) {
							
							updateFixedElementsPosition( 'open' );
						}
					}
				}
				
				return;
			}
			
			
			function updateFixedElementsPosition( divibarStatus, transition = true, position, forceHeight = null ) {
				
				var selector
				, positionTop
				, divibar_id = getActiveDivibar()
				, divibar_selector = '#divibar-' + divibar_id
				, divibar = $( divibar_selector )
				, divibarHeight = divibar.find('.divibars-body').height()
				, lastPosition
				, elemHeight
				, lastElemHeight = 0
				, currentPosition
				, keepElementPosition;
				
				if ( forceHeight ) {
					
					divibarHeight = forceHeight;
				}
				
				lastPosition = divibarHeight;
				
				$.each( fixedElements, function( index, value ) {
					
					if ( Array.isArray( value ) ) {
						
						if ( value['id'] != '' ) {
							
							selector = '#' + value['id'];
							
						} else if ( value['class'] != '' ) {
							
							selector = '.' + value['class'];
							
						} else {
							
							return true;
						}
						
						keepElementPosition = $( selector ).attr('data-position') == 'absolute' ? true : false;
						
						if ( divibarStatus == 'open' ) {
							
							lastPosition = lastPosition + lastElemHeight;
							
							positionTop = lastPosition;
							
							if ( !keepElementPosition ) {
								
								$( selector ).attr('data-position', '');
							}
						}
						else if ( divibarStatus == 'close' ) {
							
							currentPosition = parseInt( $( selector ).css('top') );
							
							lastPosition = lastPosition - lastElemHeight;
							
							positionTop = currentPosition - divibarHeight;
						}
						
						if ( transition ) {
							
							$( selector ).addClass( 'divibar-elem-transition-top' );
							
							addStyles( selector, 'top:' + positionTop + 'px !important;' );
							
						} else {
							
							addStyles( selector, 'top:' + positionTop + 'px !important;' );
							
							if ( !keepElementPosition ) {
								
								$( selector ).removeClass( 'divibar-elem-transition-top' );
								
								
								if ( position != null ) {
									
									addStyles( selector, 'position:' + position + ' !important;' );
								}
							}
							
							if ( diviMobile ) {
								
								// Except divibar, we don't want other elements position fixed in mobile while divibar is active
								if ( divibar_selector != selector ) {
									
									addStyles( selector, 'position:absolute !important;' );
								}
							}
						}
						
						elemHeight = value['css_height'];
						
						lastElemHeight = elemHeight;
					}
					
				});
			}
			
			
			function affixFixedElements( divibarHeight, divibarStatus ) {
				
				var selector
				, position
				, divibarHeight
				, keepElementPosition;
				
				$.each( fixedElements, function( index, value ) {
					
					if ( Array.isArray( value ) ) {
						
						if ( value['id'] != '' ) {
							
							selector = '#' + value['id'];
							
						} else if ( value['class'] != '' ) {
							
							selector = '.' + value['class'];
							
						} else {
							
							return true;
						}
						
						keepElementPosition = $( selector ).attr('data-position') == 'absolute' ? true : false;
						
						if ( divibarStatus == 'open' ) {
						
							position = 'absolute';
						}
						else if ( divibarStatus == 'close' ) {
							
							position = 'fixed';
						}
						
						if ( !keepElementPosition ) {
							
							addStyles( selector, 'position:' + position + ' !important;' );
						}
					}
				});
			}
			
			
			function testEvents( obj ) {
				
				var retVal = false;
				
				// Get all events bound to object
				var windowEvents = $._data(obj, "events");
				
				return;
			}
			
			
			function updateFixedElementsPositionOnly() {
				
				var selector
				, positionTop
				, divibar_id = getActiveDivibar()
				, divibar_selector = '#divibar-' + divibar_id
				, divibar = $( divibar_selector )
				, divibarHeight = divibar.find('.divibars-body').height()
				, lastPosition
				, elemHeight
				, currentElemHeight
				, lastElemHeight = 0
				, currentPosition
				, counter = 0
				, divibarScreenfixed = divibar.data('screenfixed');
				
				lastPosition = divibarHeight;
				
				$.each( fixedElements, function( index, value ) {
					
					if ( Array.isArray( value ) ) {
						
						if ( value['id'] != '' ) {
							
							selector = '#' + value['id'];
							
						} else if ( value['class'] != '' ) {
							
							selector = '.' + value['class'];
							
						} else {
							
							return true;
						}
						
						// Check only in the first interaction
						if ( scrollCheck && counter == 0 && divibarScreenfixed ) {
							
							lastPosition = 0;
							
							counter++;
						}
						
						currentElemHeight = getElemHeight( $( selector ) )
						elemHeight = value['css_height'];
						if ( currentElemHeight != elemHeight ) {
							
							elemHeight = currentElemHeight;
						}
						
						lastPosition = lastPosition + lastElemHeight;
						
						positionTop = lastPosition;
						
						addStyles( selector, 'top:' + positionTop + 'px !important;' );
						
						lastElemHeight = elemHeight;
					}
					
				});
			}
			
			
			function autoPositionAll() {
				
				var divibar_id = getActiveDivibar();
				
				diviMobile = isDiviMobile();
				
				if ( divibar_id ) {
					
					var divibar_selector = '#divibar-' + divibar_id
					, divibar = $( divibar_selector )
					, contentLength = divibar.text().length
					, divibarHeight = getElemHeight( $( divibar_selector ).find('.divibars-body') );
					
					if ( divibar.hasClass( 'divibars-opened' ) ) {
						
						divibar.css( 'height', divibarHeight );
						
						if ( 
							( contentLength != contentLengthcache ) 
							|| ( divibarHeight != divibarHeightCache ) ) {
							
							var placement = divibar.data('placement')
							, pushpage = divibar.data('pushpage')
							, screenfixed = divibar.data('screenfixed')
							, bodyPaddingTopDivibar = ( divibarHeight - cacheHtmlMarginTop ) + 'px'
							, options = [];
							
							options['pushpage'] = pushpage;
							options['placement'] = placement;
							options['screenfixed'] = screenfixed;
							options['divibarHeight'] = divibarHeight;
							options['bodyPaddingTopDivibar'] = bodyPaddingTopDivibar;
							
							$( divibar_selector ).transition({ height: divibarHeight + 'px' });
							
							// Update global variables when @media breakpoint changes between mobile and desktop
							if ( 
								( diviMobile === false && diviMobileCache === true ) 
								|| ( diviMobile === true && diviMobileCache === false )
								) {
								
								stopAutoPositionTimer();
								
								updateGlobals( options );
							}
							else {
								
								if ( pushpage ) {
									
									if ( placement == 'top' || screenfixed ) {
									
										updateFixedElementsPosition( 'open', false, null, divibarHeight );
									}
									
									pushBody( options, 'open', true );
								}
								
								contentLengthcache = contentLength;
								
								divibarHeightCache = divibarHeight;
							}
						}
						else {
							
							updateFixedElementsPositionOnly();
						}
					}
				}
			}
			
			positionTimer = setInterval( autoPositionAll, 100 );
			
			
			function updateGlobals( options ) {
				
				var placement = options['placement']
				, pushpage = options['pushpage']
				, screenfixed = options['screenfixed']
				, divibarHeight = options['divibarHeight']
				, selector;
				
				diviMobile = diviMobileCache = isDiviMobile();
				
				setTimeout( function() {
					
					removeStyles();
					
					setTimeout( function() {
						
						fixedElements = getFlyingElements();
						
						setTimeout( function() {
							
							// Remove data-position in all position fixed elements
							$.each( fixedElements, function( index, value ) {
								
								if ( Array.isArray( value ) ) {
									
									if ( value['id'] != '' ) {
										
										selector = '#' + value['id'];
										
									} else if ( value['class'] != '' ) {
										
										selector = '.' + value['class'];
										
									} else {
										
										return true;
									}
									
									$( selector ).removeAttr('data-position');
								}
								
							});
							
							setTimeout( function() {
							
								affixFixedElements( divibarHeight, 'open' );
							
								setTimeout( function() {
										
									if ( pushpage ) {
										
										if ( placement == 'top' || screenfixed ) {
										
											updateFixedElementsPosition( 'open', false, null, divibarHeight );
										}
										
										pushBody( options, 'open', true );
									}
									
									positionTimer = setInterval( autoPositionAll, 100 );
									
								}, 1);
								
							}, 1);
							
						}, 1);
						
					}, 1);
					
				}, 1);
			}
			
			
			function removeMonarch() {
				
				if ( $( '.divibars .et_social_inline' ).length ) {
					
					$( '.divibars .et_social_inline' ).parents('.et_pb_row').remove();
				}
				
				removeMonarchTimer = setTimeout(removeMonarch, 500);
			}
			
			removeMonarch();
			
			
			function stopAutoPositionTimer() {
				
				if ( positionTimer ) {
					
					clearInterval( positionTimer );
					positionTimer = 0;
				}
			}
			
			
			function getElemHeight( elem ) {
			
				var elemHeight = 0, attr;
				
				if ( elem.length ) {
				
					elemHeight = elem.outerHeight();
					
					if ( elemHeight === 0 ) {
						
						attr = elem.attr('id');
						
						if (typeof attr !== typeof undefined && attr !== false) {
							
							elemHeight = document.getElementById( attr ).offsetHeight;
						}
					}
					
					if ( elemHeight === 0 ) {
						
						elemHeight = elem.delay(100).outerHeight();
					}
					
					elemHeight = parseInt( elemHeight );
				
				}
				
				return elemHeight;
			}
			
			
			function addStyles( selector, css ) {
				
				var CSSline
				, CSSlines
				, regexCSSline
				, regex
				, divibarStylesTag = $( '#' + styleTagID )
				, divibarStylesTagContent = divibarStylesTag.text();
				
				if ( selector && selector != '#undefined' ) {
					
					CSSline = 'body.divibar-open ' + selector + ' { ' + css + ' }';
					CSSline += 'body.et_fixed_nav.et_secondary_nav_only_menu.admin-bar ' + selector + ' { ' + css + ' }';
					regexCSSline = escapeRegExp( CSSline );
					
					// Remove any duplicates
					regex = new RegExp( regexCSSline, 'g' );
					divibarStylesTagContent = divibarStylesTagContent.replace( regex, '' );
					
					// Update style tag
					divibarStylesTag.text( divibarStylesTagContent );
					
					divibarStylesTag.append( CSSline );
					
					/*
					CSSlines = divibarStylesTag.text().split('}');
					$( CSSlines ).each(function (idx, line) {
						
						if ( line.length > 2 ) {
							
						}
					});
					
					// Remove blank lines
					// divibarStylesTag.text( divibarStylesTag.text().replace(/^\s*[\r\n]/gm, '') );
					*/
				}
			}
			
			
			// Belongs to https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions
			function escapeRegExp(string) {
				return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // $& means the whole matched string
			}
			
			
			// This remove styles from Divi Bars styles tag only
			function removeStyles( selector ) {
				
				var CSSline
				, regexCSSline
				, regex
				, divibar_id = getActiveDivibar()
				, divibar_selector = '#divibar-' + divibar_id
				, divibarStylesTag = $( '#' + styleTagID )
				, divibarStylesTagContent = divibarStylesTag.text();
				
				if ( selector && selector != '#undefined' ) {
					
					selector = [ selector ];
				}
				else {
					
					selector = fixedElements;
				}
				
				$.each( selector, function( index, value ) {
					
					if ( Array.isArray( value ) ) {
						
						if ( value['id'] != '' ) {
							
							selector = '#' + value['id'];
							
						} else if ( value['class'] != '' ) {
							
							selector = '.' + value['class'];
							
						} else {
							
							return true;
						}
						
						CSSline = 'body.divibar-open ' + selector + ' { position:absolute !important; }';
						
						regexCSSline = escapeRegExp( CSSline );
						regex = new RegExp( regexCSSline, 'g' );
						divibarStylesTagContent = divibarStylesTagContent.replace( regex, '' );
						
						CSSline = 'body.et_fixed_nav.et_secondary_nav_only_menu.admin-bar ' + selector + ' { position:absolute !important; }';
						
						regexCSSline = escapeRegExp( CSSline );
						regex = new RegExp( regexCSSline, 'g' );
						divibarStylesTagContent = divibarStylesTagContent.replace( regex, '' );
						
						CSSline = 'body.divibar-open ' + selector + ' { position:fixed !important; }';
						
						regexCSSline = escapeRegExp( CSSline );
						regex = new RegExp( regexCSSline, 'g' );
						divibarStylesTagContent = divibarStylesTagContent.replace( regex, '' );
						
						CSSline = 'body.et_fixed_nav.et_secondary_nav_only_menu.admin-bar ' + selector + ' { position:fixed !important; }';
						
						regexCSSline = escapeRegExp( CSSline );
						regex = new RegExp( regexCSSline, 'g' );
						divibarStylesTagContent = divibarStylesTagContent.replace( regex, '' );
					}
				});
				
				// Update style tag
				divibarStylesTag.text( divibarStylesTagContent );
			}
			
			
			function isDiviMobile() {
				
				var currentTheme = detectTheme();
				
				// Get current device width
				vw = actual('width', 'px');
				
				diviMobile = ( vw < themesBreakpoint[ currentTheme ] ) ? true : false;
				
				return diviMobile;
			}
			
			
			function detectTheme() {
				
				var currentTheme = 'Divi';
				
				if ( $('body').hasClass('et_extra') ) {
					
					currentTheme = 'Extra';
				}
				
				return currentTheme;
			}
			
			
			function createCookie( name,value,days ) {
				
				var expires = "";
				
				if ( days ) {
					
					var date = new Date();
					
					date.setTime(date.getTime() + ( days * 24 * 60 * 60 * 1000));
					
					expires = "; expires=" + date.toUTCString();
				}
				
				document.cookie = name + "=" + value + expires + "; path=/";
			}

			function readCookie( name ) {
				
				var nameEQ = name + "=";
				var ca = document.cookie.split(';');
				
				for(var i=0;i < ca.length;i++) {
					
					var c = ca[i];
					
					while (c.charAt(0)==' ') c = c.substring(1,c.length);
					
					if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
				}
				
				return null;
			}

			function eraseCookie( name ) {
				createCookie( name, '', -1 );
			}
			
			// URL Trigger
			if ( window.location.hash ) {
				
				var hash = window.location.hash.substring( 1 );
				var idx_divibar = hash.indexOf('divibar'); 
				
				if ( idx_divibar !== -1 ) {
					
					var idx_divibarArr = hash.split('-');
					
					if ( idx_divibarArr.length > 1 ) {
						
						var divibar_id = idx_divibarArr[1];
						
						setTimeout(function() {
							
							showDivibar( divibar_id );
							
						}, 1);
					}
				}
			}
		}
		
	} // end mainDiviBars
	
	
	// Find all iframes inside the divibars
	var $dibiframes = $( "#sidebar-divibar .divibars iframe" );
	
	setTimeout( function() { 
	
		$dibiframes.each( function() {
			
			var iframeHeight = this.height;
			
			if ( iframeHeight == '' ) {
				
				iframeHeight = $( this ).height();
			}
			
			iframeWidth = this.width;
			
			if ( iframeWidth == '' ) {
				
				iframeWidth = $( this ).width();
			}
			
			iframeHeight = parseInt( iframeHeight );
			iframeWidth = parseInt( iframeWidth );
			
			var ratio = iframeHeight / iframeWidth;
			
			$( this ).attr( "data-ratio", ratio )
			// Remove the hardcoded width & height attributes
			.removeAttr( "width" )
			.removeAttr( "height" );
			
			// Get the parent container's width
			var width = $( this ).parent().width();
			
			$( this ).width( width ).height( width * ratio );
		});
		
	}, 200);
	
	// Resize the iframes when the window is resized
	$(window).on('resize orientationchange', function() {
		
		$dibiframes.each( function() {
			// Get the parent container's width
			var width = $( this ).parent().width();
			$( this ).width( width )
			.height( width * $( this ).data( "ratio" ) );
		});
		
		
	  
	});
	
	$(window).load(function() {
		
		// Divi Cascade Fix
		if ( $('#et-builder-module-design-cached-inline-styles').length && !$('#cloned-et-builder-module-design-cached-inline-styles').length ) {
			
			// Divi Cached Inline Styles
			var divicachedcss = $( '#et-builder-module-design-cached-inline-styles' );
			var divicachedcsscontent = divicachedcss.html();
			
			// Remove #page-container from Divi Cached Inline Styles tag and cloning it to prevent issues
			divicachedcsscontent = divicachedcsscontent.replace(/\#page-container/g, ' ');
			
			$( divicachedcss ).after( '<style id="cloned-et-builder-module-design-cached-inline-styles">' + divicachedcsscontent + '</style>' );
		}
		
		$('body').prepend( $( "#sidebar-divibar" ) );
		
		setTimeout(function() {
			
			$('#sidebar-divibar .divibars').mainDiviBars();
			
		}, 1);
	});
	
})( jQuery, window, document );