<?php

	class DiviBars {
		
		private static $initiated = false;
		
		/**
		 * Holds an instance of DiviBars Helper class
		 *
		 * @since 1.0
		 * @var DiviBars_Helper
		 */
		public static $helper;
		
		public static function init() {
			
			if ( ! self::$initiated ) {
				
				self::load_resources();
				
				self::$helper = new DiviBars_Helper();
				
				self::init_hooks();
				
				// Register the Custom Divi Bar Post Type
				self::register_cpt();
			}
		}
		
		/**
		 * Initializes WordPress hooks
		 */
		protected static function init_hooks() {
			
			self::$initiated = true;
			
			// Add custom column in post type
			add_filter( 'manage_edit-divi_bars_columns', array( 'DiviBars', 'setup_divibars_columns') ) ;
			add_action( 'manage_divi_bars_posts_custom_column', array( 'DiviBars', 'manage_divibars_columns' ), 10, 2 );
			
			// Add styles
			add_action( 'wp_print_styles', array( 'DiviBars', 'add_styles') );
			
			// Add scripts
			add_action( 'wp_enqueue_scripts', array( 'DiviBars', 'add_scripts') );
			
			// Ajax ready
			add_action( 'wp_head', array( 'DiviBars', 'add_var_ajaxurl') );
			add_action( 'wp_ajax_ajax_divibars_callback', array( 'DiviBars_Ajax', 'ajax_divibars_callback') );
			add_action( 'wp_ajax_nopriv_ajax_divibars_callback', array( 'DiviBars_Ajax', 'ajax_divibars_callback') );
			
			// Register widget
			add_action( 'widgets_init', array( 'DiviBars', 'register_widget') );
			
			add_action( 'wp_head', array( 'DiviBars', 'prevent_playable_tags') );
			
			// Divi Bars call
			add_action( 'wp_footer', array( 'DiviBars_Controller', 'showDiviBars' ) );
		}
		
		
		protected static function load_resources() {
			
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.controller.php' );
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.model.php' );
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.helper.php' );
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.ajax.php' );
		}
		
		
		public static function register_cpt() {
			
			$labels = array(
				'name' => _x( 'Divi Bars', 'divi_bars' ),
				'singular_name' => _x( 'Divi Bars', 'divi_bars' ),
				'add_new' => _x( 'Add New', 'divi_bars' ),
				'add_new_item' => _x( 'Add New Divi Bar', 'divi_bars' ),
				'edit_item' => _x( 'Edit Divi Bar', 'divi_bars' ),
				'new_item' => _x( 'New Divi Bar', 'divi_bars' ),
				'view_item' => _x( 'View Divi Bar', 'divi_bars' ),
				'search_items' => _x( 'Search Divi Bars', 'divi_bars' ),
				'not_found' => _x( 'No Divi Bars found', 'divi_bars' ),
				'not_found_in_trash' => _x( 'No Divi Bars found in Trash', 'divi_bars' ),
				'parent_item_colon' => _x( 'Parent Divi Bar:', 'divi_bars' ),
				'menu_name' => _x( 'Divi Bars', 'divi_bars' ),
			);
			
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'supports' => array( 'title', 'editor', 'author' ),
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'menu_position' => 5,
				'show_in_nav_menus' => true,
				'publicly_queryable' => false,
				'exclude_from_search' => true,
				'has_archive' => true,
				'query_var' => true,
				'can_export' => true,
				'rewrite' => true,
				'capability_type' => 'post'
			);
			
			register_post_type( 'divi_bars', $args );
		}
		
		
		public static function setup_divibars_columns( $columns ) {

			$columns = array(
				'cb' => '<input type="checkbox" />',
				'title' => __( 'Title' ),
				'unique_identifier' => __( 'CSS ID' ),
				'unique_menu_id' => __( 'Menu ID' ),
				'author' => __( 'Author' ),
				'date' => __( 'Date' )
			);

			return $columns;
		}
		
		
		public static function manage_divibars_columns( $column, $post_id ) {
			
			global $post;
			
			switch( $column ) {
				
				/* If displaying the 'unique-indentifier' column. */
				case 'unique_identifier':
				
					/* Get the post meta. */
					$post_slug = "divibars_unique_id_$post->ID";
					
					echo $post_slug;
					
					break;
					
				case 'unique_menu_id':
				
					/* Get the post meta. */
					$post_slug = "unique_divibars_menu_id_$post->ID";
					
					echo $post_slug;
					
					break;
					
				default:
				
					break;
			}
		}
		
		
		public static function register_widget() {
			
			register_sidebar( array(
				'name' => __( 'Divi Bars - Global', 'theme-slug' ),
				'id' => 'divi-bars_global_widget',
				'description' => __( '', 'theme-slug' )
			) );
		}
		
		
		// Register all needed stylesheets
		public static function add_styles() {
			
			wp_register_style('normalize_css', plugins_url('assets/css/normalize.css', __FILE__));
			wp_enqueue_style('normalize_css');
			
			wp_register_style('DiviBars-main', DIVI_BARS_PLUGIN_URL . 'assets/css/main.css' );
			wp_enqueue_style('DiviBars-main');
		}
		
		
		// Register all needed scripts
		public static function add_scripts() {
			
			wp_enqueue_script('jquery');
		
			wp_register_script('DiviBars-main', DIVI_BARS_PLUGIN_URL . 'assets/js/main.js', array('jquery'), DIVI_BARS_VERSION, TRUE);
			wp_enqueue_script('DiviBars-main');
			
			wp_register_script('DiviBars-main-helper', DIVI_BARS_PLUGIN_URL . 'assets/js/main.helper.js', array('jquery', 'DiviBars-main'), DIVI_BARS_VERSION, TRUE );
			wp_enqueue_script('DiviBars-main-helper');
			
			wp_register_script('snap_svg_js', plugins_url('assets/js/snap.svg-min.js', __FILE__),array("jquery"));
			wp_enqueue_script('snap_svg_js');
			
			wp_register_script('modernizr_js', plugins_url('assets/js/modernizr.custom.js', __FILE__),array("jquery"));
			wp_enqueue_script('modernizr_js');
			
			wp_register_script('jquery_transit', plugins_url('assets/js/jquery.transit.min.js', __FILE__),array("jquery"));
			wp_enqueue_script('jquery_transit');
			
			wp_register_script('actual', plugins_url('assets/js/actual.min.js', __FILE__),array("jquery"));
			wp_enqueue_script('actual');
		}
		
		
		public static function add_var_ajaxurl() {
		?>
		<script type="text/javascript">
		var ajax_url = '<?php print admin_url('admin-ajax.php'); ?>';
		</script>
		<?php
		}
		
		
		public static function prevent_playable_tags() {
			?>
			<script type="text/javascript">
				function dibTogglePlayableTags( divibar_id, wait ) {
				
					var $ = jQuery;
					
					if ( !divibar_id  ) {
						
						divibar_id = "";
					}
					
					if ( !wait  ) {
						
						wait = 1;
					}
					
					/* Prevent playable tags load content before divibar call */
					setTimeout(function() {
						
						$( divibar_id + ".divibars").find("iframe").each(function() { 
						
							var iframeParent = $(this).parent();
							var iframe = $(this).prop("outerHTML");
							var src = iframe.match(/src=[\'"]?((?:(?!\/>|>|"|\'|\s).)+)"/)[0];
							
							src = src.replace("src", "data-src");
							iframe = iframe.replace(/src=".*?"/i, "src=\"about:blank\" data-src=\"\"" );
							
							if ( src != "data-src=\"about:blank\"" ) {
								iframe = iframe.replace("data-src=\"\"", src );
							}
							
							$( iframe ).insertAfter( $(this) );
							
							$(this).remove();
						});
						
					}, wait);
					
					$( divibar_id + ".divibars").find("video").each(function() {
						$(this).get(0).pause();
					});
					
					$( divibar_id + ".divibars").find("audio").each(function() {
						
						this.pause();
						this.currentTime = 0;
					});
				}
				
				dibTogglePlayableTags( '', 1000 );
			</script>
			<?php
		}
	}