<?php

	class DiviBars_Helper {
		
		public function __construct() {
			
		}
		
		public static function get_all_wordpress_menus(){
			return get_terms( 'nav_menu', array( 'hide_empty' => true ) ); 
		}
		
		
		public static function prepareBars( $key = NULL )
		{
			try {
				
				if ( !$key ) {
					
					throw new InvalidArgumentException( 'DiviBars_Helper::prepareBars > Required var $key');
					
				}
				
				// it is an url with hash divibars?
				if ( strpos( $key, "#" ) !== false ) {
					
					$exploded_url = explode( "#", $key );
					
					if ( isset( $exploded_url[1] ) ) {
						
						$key = str_replace( 'divibars-', '', $exploded_url[1] );
					}
				}
				
				$key = str_replace( 'divibars_', '', $key );
				$key = str_replace( 'unique_id_', '', $key );
				$key = str_replace( 'divibars-', '', $key );
				
				if ( $key == '' ) {
					return NULL;
				}
				
				if ( !self::barIsPublished( $key ) ) {
					
					return NULL;
				}
				
				return $key;
				
			} catch (Exception $e) {
				
				DiviBars_Controller::log( $e );
				
				return NULL;
			}
		}
		
		
		private static function barIsPublished( $key ) {
			
			try {
			
				$post = get_post_status( $key );
			
			} catch (Exception $e) {
			
				DiviBars_Controller::log( $e );
				
				return FALSE;
			}
			
			if ( $post != 'publish' ) {
				
				return FALSE;
			}
			
			return TRUE;
		}
		
		
		// Checks multidimensional array like in_array function.
		public static function in_multiarray($elem, $array)
		{
			$top = sizeof($array) - 1;
			$bottom = 0;
			while($bottom <= $top)
			{
				if($array[$bottom] == $elem)
					return true;
				else
					if(is_array($array[$bottom]))
						if(in_multiarray($elem, ($array[$bottom])))
							return true;
					   
				$bottom++;
			}       
			return false;
		}
		
		
		// Fastest way to check if a string is JSON
		public static function isJson($string) {
		
			json_decode($string);
			
			return ( json_last_error() == JSON_ERROR_NONE );
		}
		
		
		public static function convertDateToUTC( $date = null, $timezone = DIVI_SERVER_TIMEZONE, $format = DIVI_SCHEDULING_DATETIME_FORMAT ) {
			
			if ( $date === null ) {
				
				return;
			}
			
			if ( !self::validateDate( $date, $format ) ) {
				
				return;
			}
			
			$date = new DateTime( $date, new DateTimeZone( $timezone ) );
			$date->setTimezone( new DateTimeZone( DIVI_SERVER_TIMEZONE ) );
			$str_server_now = $date->format( $format );
			
			return $str_server_now;
		}
		
		
		public static function convertDateToUserTimezone( $date = null, $format = DIVI_SCHEDULING_DATETIME_FORMAT ) {
			
			if ( $date === null ) {
				
				return;
			}
			
			if ( !self::validateDate( $date, $format ) ) {
				
				return;
			}
			
			$divibars_settings = get_option( 'dib_settings' );
			
			$timezone = DIVI_SERVER_TIMEZONE;
			
			if ( isset( $divibars_settings['dib_timezone'] ) ) {
				
				$timezone = $divibars_settings['dib_timezone'];
			}
			
			$date = new DateTime( $date, new DateTimeZone( DIVI_SERVER_TIMEZONE ) );
			$date->setTimezone( new DateTimeZone( $timezone ) );
			$str_server_now = $date->format( $format );
			
			return $str_server_now;
		}
		
		
		public static function validateDate( $dateStr, $format ) {
			
			$date = DateTime::createFromFormat($format, $dateStr);
			
			return $date && ($date->format($format) === $dateStr);
		}
	}
	
	