<?php

/**
* @package Divi_Image_N10S
* @version 3.2.5
*/

/*
* Plugin Name: Divi Image Intense
* Plugin URI: https://besuperfly.com/product/image-intense/
* Description: A hybrid mix of the Image, Text and Button modules. Includes Superfly text, overlay, blend, hover, button and background effect options!
* Author: Superfly
* Version: 3.2.5
* Author URI: https://besuperfly.com/about-superfly/
* License: GPL3
*/

// This function will be hooked given that the Divi Builder is being used
function N10S_Custom_Modules() {
	if ( class_exists( "ET_Builder_Module" ) ) {
		include( "n10s-custom-modules.php" );
 	}
}

// Intialize this custom module if the Builder is being used
add_action( 'et_builder_ready', 'N10S_Custom_Modules');

// Grab our n10s styling and scripts
add_action( 'wp_enqueue_scripts', 'n10s_enqueue_styles' );

function n10s_enqueue_styles() {
	wp_enqueue_style( 'n10s-hover', plugin_dir_url( __FILE__ ) . 'styles/n10s-styles.css' );
}

// Grab the n10s admin styling and add the js script file
add_action( 'admin_enqueue_scripts', 'n10s_enqueue_admin_style' );

function n10s_enqueue_admin_style() {
	wp_register_style( 'n10s_admin_style', plugin_dir_url( __FILE__ ) . 'styles/n10s-admin-style.css' );
	wp_enqueue_style( 'n10s_admin_style' );
}

/* Plugin updater section - 
	courtesy of Jānis Elsts at GitHub https://github.com/YahnisElsts/wp-update-server
*/

// Make it harder to find latest version. Keeps the honest people honest.
$updater = base64_decode('aHR0cHM6Ly9iZXN1cGVyZmx5LmNvbS90aGVtZXMtcGx1Z2lucy11cGRhdGVyL3BhY2thZ2VzL2ltYWdlLWludGVuc2UvaW1hZ2UtaW50ZW5zZS5qc29u');

require 'plugin-update-checker/plugin-update-checker.php';
$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    $updater,
    __FILE__,
    'image-intense'
);